package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePackageState invokes the cas.DescribePackageState API synchronously
func (client *Client) DescribePackageState(request *DescribePackageStateRequest) (response *DescribePackageStateResponse, err error) {
	response = CreateDescribePackageStateResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePackageStateWithChan invokes the cas.DescribePackageState API asynchronously
func (client *Client) DescribePackageStateWithChan(request *DescribePackageStateRequest) (<-chan *DescribePackageStateResponse, <-chan error) {
	responseChan := make(chan *DescribePackageStateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePackageState(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePackageStateWithCallback invokes the cas.DescribePackageState API asynchronously
func (client *Client) DescribePackageStateWithCallback(request *DescribePackageStateRequest, callback func(response *DescribePackageStateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePackageStateResponse
		var err error
		defer close(result)
		response, err = client.DescribePackageState(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePackageStateRequest is the request struct for api DescribePackageState
type DescribePackageStateRequest struct {
	*requests.RpcRequest
	SourceIp    string `position:"Query" name:"SourceIp"`
	ProductCode string `position:"Query" name:"ProductCode"`
}

// DescribePackageStateResponse is the response struct for api DescribePackageState
type DescribePackageStateResponse struct {
	*responses.BaseResponse
	IssuedCount int64  `json:"IssuedCount" xml:"IssuedCount"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	TotalCount  int64  `json:"TotalCount" xml:"TotalCount"`
	ProductCode string `json:"ProductCode" xml:"ProductCode"`
	UsedCount   int64  `json:"UsedCount" xml:"UsedCount"`
}

// CreateDescribePackageStateRequest creates a request to invoke DescribePackageState API
func CreateDescribePackageStateRequest() (request *DescribePackageStateRequest) {
	request = &DescribePackageStateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-04-07", "DescribePackageState", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePackageStateResponse creates a response to parse from DescribePackageState response
func CreateDescribePackageStateResponse() (response *DescribePackageStateResponse) {
	response = &DescribePackageStateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
