package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGeographicRegionMembership invokes the cbn.DescribeGeographicRegionMembership API synchronously
func (client *Client) DescribeGeographicRegionMembership(request *DescribeGeographicRegionMembershipRequest) (response *DescribeGeographicRegionMembershipResponse, err error) {
	response = CreateDescribeGeographicRegionMembershipResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGeographicRegionMembershipWithChan invokes the cbn.DescribeGeographicRegionMembership API asynchronously
func (client *Client) DescribeGeographicRegionMembershipWithChan(request *DescribeGeographicRegionMembershipRequest) (<-chan *DescribeGeographicRegionMembershipResponse, <-chan error) {
	responseChan := make(chan *DescribeGeographicRegionMembershipResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGeographicRegionMembership(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGeographicRegionMembershipWithCallback invokes the cbn.DescribeGeographicRegionMembership API asynchronously
func (client *Client) DescribeGeographicRegionMembershipWithCallback(request *DescribeGeographicRegionMembershipRequest, callback func(response *DescribeGeographicRegionMembershipResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGeographicRegionMembershipResponse
		var err error
		defer close(result)
		response, err = client.DescribeGeographicRegionMembership(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGeographicRegionMembershipRequest is the request struct for api DescribeGeographicRegionMembership
type DescribeGeographicRegionMembershipRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Version              string           `position:"Query" name:"Version"`
	GeographicRegionId   string           `position:"Query" name:"GeographicRegionId"`
}

// DescribeGeographicRegionMembershipResponse is the response struct for api DescribeGeographicRegionMembership
type DescribeGeographicRegionMembershipResponse struct {
	*responses.BaseResponse
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	PageNumber int       `json:"PageNumber" xml:"PageNumber"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	RegionIds  RegionIds `json:"RegionIds" xml:"RegionIds"`
}

// CreateDescribeGeographicRegionMembershipRequest creates a request to invoke DescribeGeographicRegionMembership API
func CreateDescribeGeographicRegionMembershipRequest() (request *DescribeGeographicRegionMembershipRequest) {
	request = &DescribeGeographicRegionMembershipRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DescribeGeographicRegionMembership", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGeographicRegionMembershipResponse creates a response to parse from DescribeGeographicRegionMembership response
func CreateDescribeGeographicRegionMembershipResponse() (response *DescribeGeographicRegionMembershipResponse) {
	response = &DescribeGeographicRegionMembershipResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
