package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GrantNetLink invokes the cc5g.GrantNetLink API synchronously
func (client *Client) GrantNetLink(request *GrantNetLinkRequest) (response *GrantNetLinkResponse, err error) {
	response = CreateGrantNetLinkResponse()
	err = client.DoAction(request, response)
	return
}

// GrantNetLinkWithChan invokes the cc5g.GrantNetLink API asynchronously
func (client *Client) GrantNetLinkWithChan(request *GrantNetLinkRequest) (<-chan *GrantNetLinkResponse, <-chan error) {
	responseChan := make(chan *GrantNetLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GrantNetLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GrantNetLinkWithCallback invokes the cc5g.GrantNetLink API asynchronously
func (client *Client) GrantNetLinkWithCallback(request *GrantNetLinkRequest, callback func(response *GrantNetLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GrantNetLinkResponse
		var err error
		defer close(result)
		response, err = client.GrantNetLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GrantNetLinkRequest is the request struct for api GrantNetLink
type GrantNetLinkRequest struct {
	*requests.RpcRequest
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	NetLinkId                string           `position:"Query" name:"NetLinkId"`
	ClientToken              string           `position:"Query" name:"ClientToken"`
	GrantAliUid              requests.Integer `position:"Query" name:"GrantAliUid"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
}

// GrantNetLinkResponse is the response struct for api GrantNetLink
type GrantNetLinkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGrantNetLinkRequest creates a request to invoke GrantNetLink API
func CreateGrantNetLinkRequest() (request *GrantNetLinkRequest) {
	request = &GrantNetLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "GrantNetLink", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGrantNetLinkResponse creates a response to parse from GrantNetLink response
func CreateGrantNetLinkResponse() (response *GrantNetLinkResponse) {
	response = &GrantNetLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
