package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWirelessCloudConnector invokes the cc5g.UpdateWirelessCloudConnector API synchronously
func (client *Client) UpdateWirelessCloudConnector(request *UpdateWirelessCloudConnectorRequest) (response *UpdateWirelessCloudConnectorResponse, err error) {
	response = CreateUpdateWirelessCloudConnectorResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWirelessCloudConnectorWithChan invokes the cc5g.UpdateWirelessCloudConnector API asynchronously
func (client *Client) UpdateWirelessCloudConnectorWithChan(request *UpdateWirelessCloudConnectorRequest) (<-chan *UpdateWirelessCloudConnectorResponse, <-chan error) {
	responseChan := make(chan *UpdateWirelessCloudConnectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWirelessCloudConnector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWirelessCloudConnectorWithCallback invokes the cc5g.UpdateWirelessCloudConnector API asynchronously
func (client *Client) UpdateWirelessCloudConnectorWithCallback(request *UpdateWirelessCloudConnectorRequest, callback func(response *UpdateWirelessCloudConnectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWirelessCloudConnectorResponse
		var err error
		defer close(result)
		response, err = client.UpdateWirelessCloudConnector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWirelessCloudConnectorRequest is the request struct for api UpdateWirelessCloudConnector
type UpdateWirelessCloudConnectorRequest struct {
	*requests.RpcRequest
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken              string           `position:"Query" name:"ClientToken"`
	Description              string           `position:"Query" name:"Description"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
	Name                     string           `position:"Query" name:"Name"`
}

// UpdateWirelessCloudConnectorResponse is the response struct for api UpdateWirelessCloudConnector
type UpdateWirelessCloudConnectorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateWirelessCloudConnectorRequest creates a request to invoke UpdateWirelessCloudConnector API
func CreateUpdateWirelessCloudConnectorRequest() (request *UpdateWirelessCloudConnectorRequest) {
	request = &UpdateWirelessCloudConnectorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "UpdateWirelessCloudConnector", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateWirelessCloudConnectorResponse creates a response to parse from UpdateWirelessCloudConnector response
func CreateUpdateWirelessCloudConnectorResponse() (response *UpdateWirelessCloudConnectorResponse) {
	response = &UpdateWirelessCloudConnectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
