package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAudioFileDownloadUrl invokes the ccc.GetAudioFileDownloadUrl API synchronously
func (client *Client) GetAudioFileDownloadUrl(request *GetAudioFileDownloadUrlRequest) (response *GetAudioFileDownloadUrlResponse, err error) {
	response = CreateGetAudioFileDownloadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// GetAudioFileDownloadUrlWithChan invokes the ccc.GetAudioFileDownloadUrl API asynchronously
func (client *Client) GetAudioFileDownloadUrlWithChan(request *GetAudioFileDownloadUrlRequest) (<-chan *GetAudioFileDownloadUrlResponse, <-chan error) {
	responseChan := make(chan *GetAudioFileDownloadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAudioFileDownloadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAudioFileDownloadUrlWithCallback invokes the ccc.GetAudioFileDownloadUrl API asynchronously
func (client *Client) GetAudioFileDownloadUrlWithCallback(request *GetAudioFileDownloadUrlRequest, callback func(response *GetAudioFileDownloadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAudioFileDownloadUrlResponse
		var err error
		defer close(result)
		response, err = client.GetAudioFileDownloadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAudioFileDownloadUrlRequest is the request struct for api GetAudioFileDownloadUrl
type GetAudioFileDownloadUrlRequest struct {
	*requests.RpcRequest
	InstanceId      string `position:"Query" name:"InstanceId"`
	AudioResourceId string `position:"Query" name:"AudioResourceId"`
}

// GetAudioFileDownloadUrlResponse is the response struct for api GetAudioFileDownloadUrl
type GetAudioFileDownloadUrlResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateGetAudioFileDownloadUrlRequest creates a request to invoke GetAudioFileDownloadUrl API
func CreateGetAudioFileDownloadUrlRequest() (request *GetAudioFileDownloadUrlRequest) {
	request = &GetAudioFileDownloadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "GetAudioFileDownloadUrl", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAudioFileDownloadUrlResponse creates a response to parse from GetAudioFileDownloadUrl response
func CreateGetAudioFileDownloadUrlResponse() (response *GetAudioFileDownloadUrlResponse) {
	response = &GetAudioFileDownloadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
