package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCustomizeRule invokes the cloud_siem.DeleteCustomizeRule API synchronously
func (client *Client) DeleteCustomizeRule(request *DeleteCustomizeRuleRequest) (response *DeleteCustomizeRuleResponse, err error) {
	response = CreateDeleteCustomizeRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCustomizeRuleWithChan invokes the cloud_siem.DeleteCustomizeRule API asynchronously
func (client *Client) DeleteCustomizeRuleWithChan(request *DeleteCustomizeRuleRequest) (<-chan *DeleteCustomizeRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteCustomizeRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCustomizeRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCustomizeRuleWithCallback invokes the cloud_siem.DeleteCustomizeRule API asynchronously
func (client *Client) DeleteCustomizeRuleWithCallback(request *DeleteCustomizeRuleRequest, callback func(response *DeleteCustomizeRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCustomizeRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteCustomizeRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCustomizeRuleRequest is the request struct for api DeleteCustomizeRule
type DeleteCustomizeRuleRequest struct {
	*requests.RpcRequest
	RuleId requests.Integer `position:"Body" name:"RuleId"`
}

// DeleteCustomizeRuleResponse is the response struct for api DeleteCustomizeRule
type DeleteCustomizeRuleResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      int    `json:"Data" xml:"Data"`
}

// CreateDeleteCustomizeRuleRequest creates a request to invoke DeleteCustomizeRule API
func CreateDeleteCustomizeRuleRequest() (request *DeleteCustomizeRuleRequest) {
	request = &DeleteCustomizeRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DeleteCustomizeRule", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCustomizeRuleResponse creates a response to parse from DeleteCustomizeRule response
func CreateDeleteCustomizeRuleResponse() (response *DeleteCustomizeRuleResponse) {
	response = &DeleteCustomizeRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
