package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserBuyStatus invokes the cloud_siem.DescribeUserBuyStatus API synchronously
func (client *Client) DescribeUserBuyStatus(request *DescribeUserBuyStatusRequest) (response *DescribeUserBuyStatusResponse, err error) {
	response = CreateDescribeUserBuyStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserBuyStatusWithChan invokes the cloud_siem.DescribeUserBuyStatus API asynchronously
func (client *Client) DescribeUserBuyStatusWithChan(request *DescribeUserBuyStatusRequest) (<-chan *DescribeUserBuyStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeUserBuyStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserBuyStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserBuyStatusWithCallback invokes the cloud_siem.DescribeUserBuyStatus API asynchronously
func (client *Client) DescribeUserBuyStatusWithCallback(request *DescribeUserBuyStatusRequest, callback func(response *DescribeUserBuyStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserBuyStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserBuyStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserBuyStatusRequest is the request struct for api DescribeUserBuyStatus
type DescribeUserBuyStatusRequest struct {
	*requests.RpcRequest
	SubUserId requests.Integer `position:"Body" name:"SubUserId"`
}

// DescribeUserBuyStatusResponse is the response struct for api DescribeUserBuyStatus
type DescribeUserBuyStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeUserBuyStatusRequest creates a request to invoke DescribeUserBuyStatus API
func CreateDescribeUserBuyStatusRequest() (request *DescribeUserBuyStatusRequest) {
	request = &DescribeUserBuyStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DescribeUserBuyStatus", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUserBuyStatusResponse creates a response to parse from DescribeUserBuyStatus response
func CreateDescribeUserBuyStatusResponse() (response *DescribeUserBuyStatusResponse) {
	response = &DescribeUserBuyStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
