package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetLogs invokes the cloud_siem.GetLogs API synchronously
func (client *Client) GetLogs(request *GetLogsRequest) (response *GetLogsResponse, err error) {
	response = CreateGetLogsResponse()
	err = client.DoAction(request, response)
	return
}

// GetLogsWithChan invokes the cloud_siem.GetLogs API asynchronously
func (client *Client) GetLogsWithChan(request *GetLogsRequest) (<-chan *GetLogsResponse, <-chan error) {
	responseChan := make(chan *GetLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetLogsWithCallback invokes the cloud_siem.GetLogs API asynchronously
func (client *Client) GetLogsWithCallback(request *GetLogsRequest, callback func(response *GetLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetLogsResponse
		var err error
		defer close(result)
		response, err = client.GetLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetLogsRequest is the request struct for api GetLogs
type GetLogsRequest struct {
	*requests.RpcRequest
	Total        requests.Integer `position:"Body" name:"Total"`
	PageSize     requests.Integer `position:"Body" name:"PageSize"`
	From         requests.Integer `position:"Body" name:"From"`
	PageIndex    requests.Integer `position:"Body" name:"PageIndex"`
	ReverseOrNot requests.Boolean `position:"Body" name:"ReverseOrNot"`
	Query        string           `position:"Body" name:"Query"`
	To           requests.Integer `position:"Body" name:"To"`
}

// GetLogsResponse is the response struct for api GetLogs
type GetLogsResponse struct {
	*responses.BaseResponse
	Success   bool          `json:"Success" xml:"Success"`
	Code      int           `json:"Code" xml:"Code"`
	Message   string        `json:"Message" xml:"Message"`
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Data      DataInGetLogs `json:"Data" xml:"Data"`
}

// CreateGetLogsRequest creates a request to invoke GetLogs API
func CreateGetLogsRequest() (request *GetLogsRequest) {
	request = &GetLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "GetLogs", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetLogsResponse creates a response to parse from GetLogs response
func CreateGetLogsResponse() (response *GetLogsResponse) {
	response = &GetLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
