package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApiHistory invokes the cloudapi.DescribeApiHistory API synchronously
func (client *Client) DescribeApiHistory(request *DescribeApiHistoryRequest) (response *DescribeApiHistoryResponse, err error) {
	response = CreateDescribeApiHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApiHistoryWithChan invokes the cloudapi.DescribeApiHistory API asynchronously
func (client *Client) DescribeApiHistoryWithChan(request *DescribeApiHistoryRequest) (<-chan *DescribeApiHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeApiHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApiHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApiHistoryWithCallback invokes the cloudapi.DescribeApiHistory API asynchronously
func (client *Client) DescribeApiHistoryWithCallback(request *DescribeApiHistoryRequest, callback func(response *DescribeApiHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApiHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeApiHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApiHistoryRequest is the request struct for api DescribeApiHistory
type DescribeApiHistoryRequest struct {
	*requests.RpcRequest
	StageName          string `position:"Query" name:"StageName"`
	GroupId            string `position:"Query" name:"GroupId"`
	ResourceOwnerToken string `position:"Query" name:"ResourceOwnerToken"`
	SecurityToken      string `position:"Query" name:"SecurityToken"`
	ApiId              string `position:"Query" name:"ApiId"`
	HistoryVersion     string `position:"Query" name:"HistoryVersion"`
}

// DescribeApiHistoryResponse is the response struct for api DescribeApiHistory
type DescribeApiHistoryResponse struct {
	*responses.BaseResponse
	Status                 string                                     `json:"Status" xml:"Status"`
	ApiId                  string                                     `json:"ApiId" xml:"ApiId"`
	ResultType             string                                     `json:"ResultType" xml:"ResultType"`
	WebSocketApiType       string                                     `json:"WebSocketApiType" xml:"WebSocketApiType"`
	DisableInternet        bool                                       `json:"DisableInternet" xml:"DisableInternet"`
	ResultBodyModel        string                                     `json:"ResultBodyModel" xml:"ResultBodyModel"`
	ResultSample           string                                     `json:"ResultSample" xml:"ResultSample"`
	AppCodeAuthType        string                                     `json:"AppCodeAuthType" xml:"AppCodeAuthType"`
	AllowSignatureMethod   string                                     `json:"AllowSignatureMethod" xml:"AllowSignatureMethod"`
	RegionId               string                                     `json:"RegionId" xml:"RegionId"`
	ForceNonceCheck        bool                                       `json:"ForceNonceCheck" xml:"ForceNonceCheck"`
	Visibility             string                                     `json:"Visibility" xml:"Visibility"`
	FailResultSample       string                                     `json:"FailResultSample" xml:"FailResultSample"`
	AuthType               string                                     `json:"AuthType" xml:"AuthType"`
	RequestId              string                                     `json:"RequestId" xml:"RequestId"`
	Description            string                                     `json:"Description" xml:"Description"`
	GroupName              string                                     `json:"GroupName" xml:"GroupName"`
	GroupId                string                                     `json:"GroupId" xml:"GroupId"`
	DeployedTime           string                                     `json:"DeployedTime" xml:"DeployedTime"`
	StageName              string                                     `json:"StageName" xml:"StageName"`
	HistoryVersion         string                                     `json:"HistoryVersion" xml:"HistoryVersion"`
	ApiName                string                                     `json:"ApiName" xml:"ApiName"`
	BackendEnable          bool                                       `json:"BackendEnable" xml:"BackendEnable"`
	BackendConfig          BackendConfig                              `json:"BackendConfig" xml:"BackendConfig"`
	RequestConfig          RequestConfig                              `json:"RequestConfig" xml:"RequestConfig"`
	ServiceConfig          ServiceConfig                              `json:"ServiceConfig" xml:"ServiceConfig"`
	OpenIdConnectConfig    OpenIdConnectConfig                        `json:"OpenIdConnectConfig" xml:"OpenIdConnectConfig"`
	ErrorCodeSamples       ErrorCodeSamplesInDescribeApiHistory       `json:"ErrorCodeSamples" xml:"ErrorCodeSamples"`
	ResultDescriptions     ResultDescriptionsInDescribeApiHistory     `json:"ResultDescriptions" xml:"ResultDescriptions"`
	SystemParameters       SystemParametersInDescribeApiHistory       `json:"SystemParameters" xml:"SystemParameters"`
	CustomSystemParameters CustomSystemParametersInDescribeApiHistory `json:"CustomSystemParameters" xml:"CustomSystemParameters"`
	ConstantParameters     ConstantParametersInDescribeApiHistory     `json:"ConstantParameters" xml:"ConstantParameters"`
	RequestParameters      RequestParametersInDescribeApiHistory      `json:"RequestParameters" xml:"RequestParameters"`
	ServiceParameters      ServiceParametersInDescribeApiHistory      `json:"ServiceParameters" xml:"ServiceParameters"`
	ServiceParametersMap   ServiceParametersMapInDescribeApiHistory   `json:"ServiceParametersMap" xml:"ServiceParametersMap"`
}

// CreateDescribeApiHistoryRequest creates a request to invoke DescribeApiHistory API
func CreateDescribeApiHistoryRequest() (request *DescribeApiHistoryRequest) {
	request = &DescribeApiHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeApiHistory", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApiHistoryResponse creates a response to parse from DescribeApiHistory response
func CreateDescribeApiHistoryResponse() (response *DescribeApiHistoryResponse) {
	response = &DescribeApiHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
