package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApiProductsByApp invokes the cloudapi.DescribeApiProductsByApp API synchronously
func (client *Client) DescribeApiProductsByApp(request *DescribeApiProductsByAppRequest) (response *DescribeApiProductsByAppResponse, err error) {
	response = CreateDescribeApiProductsByAppResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApiProductsByAppWithChan invokes the cloudapi.DescribeApiProductsByApp API asynchronously
func (client *Client) DescribeApiProductsByAppWithChan(request *DescribeApiProductsByAppRequest) (<-chan *DescribeApiProductsByAppResponse, <-chan error) {
	responseChan := make(chan *DescribeApiProductsByAppResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApiProductsByApp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApiProductsByAppWithCallback invokes the cloudapi.DescribeApiProductsByApp API asynchronously
func (client *Client) DescribeApiProductsByAppWithCallback(request *DescribeApiProductsByAppRequest, callback func(response *DescribeApiProductsByAppResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApiProductsByAppResponse
		var err error
		defer close(result)
		response, err = client.DescribeApiProductsByApp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApiProductsByAppRequest is the request struct for api DescribeApiProductsByApp
type DescribeApiProductsByAppRequest struct {
	*requests.RpcRequest
	PageNumber    requests.Integer `position:"Query" name:"PageNumber"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	AppId         requests.Integer `position:"Query" name:"AppId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeApiProductsByAppResponse is the response struct for api DescribeApiProductsByApp
type DescribeApiProductsByAppResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	PageSize           int                `json:"PageSize" xml:"PageSize"`
	PageNumber         int                `json:"PageNumber" xml:"PageNumber"`
	TotalCount         int                `json:"TotalCount" xml:"TotalCount"`
	ApiProductInfoList ApiProductInfoList `json:"ApiProductInfoList" xml:"ApiProductInfoList"`
}

// CreateDescribeApiProductsByAppRequest creates a request to invoke DescribeApiProductsByApp API
func CreateDescribeApiProductsByAppRequest() (request *DescribeApiProductsByAppRequest) {
	request = &DescribeApiProductsByAppRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeApiProductsByApp", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeApiProductsByAppResponse creates a response to parse from DescribeApiProductsByApp response
func CreateDescribeApiProductsByAppResponse() (response *DescribeApiProductsByAppResponse) {
	response = &DescribeApiProductsByAppResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
