package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstancePackets invokes the cloudapi.DescribeInstancePackets API synchronously
func (client *Client) DescribeInstancePackets(request *DescribeInstancePacketsRequest) (response *DescribeInstancePacketsResponse, err error) {
	response = CreateDescribeInstancePacketsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstancePacketsWithChan invokes the cloudapi.DescribeInstancePackets API asynchronously
func (client *Client) DescribeInstancePacketsWithChan(request *DescribeInstancePacketsRequest) (<-chan *DescribeInstancePacketsResponse, <-chan error) {
	responseChan := make(chan *DescribeInstancePacketsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstancePackets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstancePacketsWithCallback invokes the cloudapi.DescribeInstancePackets API asynchronously
func (client *Client) DescribeInstancePacketsWithCallback(request *DescribeInstancePacketsRequest, callback func(response *DescribeInstancePacketsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstancePacketsResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstancePackets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstancePacketsRequest is the request struct for api DescribeInstancePackets
type DescribeInstancePacketsRequest struct {
	*requests.RpcRequest
	EndTime       string `position:"Query" name:"EndTime"`
	StartTime     string `position:"Query" name:"StartTime"`
	SbcName       string `position:"Query" name:"SbcName"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeInstancePacketsResponse is the response struct for api DescribeInstancePackets
type DescribeInstancePacketsResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	InstancePackets InstancePackets `json:"InstancePackets" xml:"InstancePackets"`
}

// CreateDescribeInstancePacketsRequest creates a request to invoke DescribeInstancePackets API
func CreateDescribeInstancePacketsRequest() (request *DescribeInstancePacketsRequest) {
	request = &DescribeInstancePacketsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "DescribeInstancePackets", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstancePacketsResponse creates a response to parse from DescribeInstancePackets response
func CreateDescribeInstancePacketsResponse() (response *DescribeInstancePacketsResponse) {
	response = &DescribeInstancePacketsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
