package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVpcAccessAndUpdateApis invokes the cloudapi.ModifyVpcAccessAndUpdateApis API synchronously
func (client *Client) ModifyVpcAccessAndUpdateApis(request *ModifyVpcAccessAndUpdateApisRequest) (response *ModifyVpcAccessAndUpdateApisResponse, err error) {
	response = CreateModifyVpcAccessAndUpdateApisResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVpcAccessAndUpdateApisWithChan invokes the cloudapi.ModifyVpcAccessAndUpdateApis API asynchronously
func (client *Client) ModifyVpcAccessAndUpdateApisWithChan(request *ModifyVpcAccessAndUpdateApisRequest) (<-chan *ModifyVpcAccessAndUpdateApisResponse, <-chan error) {
	responseChan := make(chan *ModifyVpcAccessAndUpdateApisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVpcAccessAndUpdateApis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVpcAccessAndUpdateApisWithCallback invokes the cloudapi.ModifyVpcAccessAndUpdateApis API asynchronously
func (client *Client) ModifyVpcAccessAndUpdateApisWithCallback(request *ModifyVpcAccessAndUpdateApisRequest, callback func(response *ModifyVpcAccessAndUpdateApisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVpcAccessAndUpdateApisResponse
		var err error
		defer close(result)
		response, err = client.ModifyVpcAccessAndUpdateApis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVpcAccessAndUpdateApisRequest is the request struct for api ModifyVpcAccessAndUpdateApis
type ModifyVpcAccessAndUpdateApisRequest struct {
	*requests.RpcRequest
	Refresh           requests.Boolean `position:"Query" name:"Refresh"`
	Token             string           `position:"Query" name:"Token"`
	InstanceId        string           `position:"Query" name:"InstanceId"`
	NeedBatchWork     requests.Boolean `position:"Query" name:"NeedBatchWork"`
	VpcTargetHostName string           `position:"Query" name:"VpcTargetHostName"`
	SecurityToken     string           `position:"Query" name:"SecurityToken"`
	Port              requests.Integer `position:"Query" name:"Port"`
	VpcId             string           `position:"Query" name:"VpcId"`
	Name              string           `position:"Query" name:"Name"`
}

// ModifyVpcAccessAndUpdateApisResponse is the response struct for api ModifyVpcAccessAndUpdateApis
type ModifyVpcAccessAndUpdateApisResponse struct {
	*responses.BaseResponse
	OperationId string `json:"OperationId" xml:"OperationId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVpcAccessAndUpdateApisRequest creates a request to invoke ModifyVpcAccessAndUpdateApis API
func CreateModifyVpcAccessAndUpdateApisRequest() (request *ModifyVpcAccessAndUpdateApisRequest) {
	request = &ModifyVpcAccessAndUpdateApisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "ModifyVpcAccessAndUpdateApis", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyVpcAccessAndUpdateApisResponse creates a response to parse from ModifyVpcAccessAndUpdateApis response
func CreateModifyVpcAccessAndUpdateApisResponse() (response *ModifyVpcAccessAndUpdateApisResponse) {
	response = &ModifyVpcAccessAndUpdateApisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
