package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenApiGatewayService invokes the cloudapi.OpenApiGatewayService API synchronously
func (client *Client) OpenApiGatewayService(request *OpenApiGatewayServiceRequest) (response *OpenApiGatewayServiceResponse, err error) {
	response = CreateOpenApiGatewayServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenApiGatewayServiceWithChan invokes the cloudapi.OpenApiGatewayService API asynchronously
func (client *Client) OpenApiGatewayServiceWithChan(request *OpenApiGatewayServiceRequest) (<-chan *OpenApiGatewayServiceResponse, <-chan error) {
	responseChan := make(chan *OpenApiGatewayServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenApiGatewayService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenApiGatewayServiceWithCallback invokes the cloudapi.OpenApiGatewayService API asynchronously
func (client *Client) OpenApiGatewayServiceWithCallback(request *OpenApiGatewayServiceRequest, callback func(response *OpenApiGatewayServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenApiGatewayServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenApiGatewayService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenApiGatewayServiceRequest is the request struct for api OpenApiGatewayService
type OpenApiGatewayServiceRequest struct {
	*requests.RpcRequest
}

// OpenApiGatewayServiceResponse is the response struct for api OpenApiGatewayService
type OpenApiGatewayServiceResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenApiGatewayServiceRequest creates a request to invoke OpenApiGatewayService API
func CreateOpenApiGatewayServiceRequest() (request *OpenApiGatewayServiceRequest) {
	request = &OpenApiGatewayServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "OpenApiGatewayService", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOpenApiGatewayServiceResponse creates a response to parse from OpenApiGatewayService response
func CreateOpenApiGatewayServiceResponse() (response *OpenApiGatewayServiceResponse) {
	response = &OpenApiGatewayServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
