package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Mobile3MetaSimpleStandardVerify invokes the cloudauth.Mobile3MetaSimpleStandardVerify API synchronously
func (client *Client) Mobile3MetaSimpleStandardVerify(request *Mobile3MetaSimpleStandardVerifyRequest) (response *Mobile3MetaSimpleStandardVerifyResponse, err error) {
	response = CreateMobile3MetaSimpleStandardVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// Mobile3MetaSimpleStandardVerifyWithChan invokes the cloudauth.Mobile3MetaSimpleStandardVerify API asynchronously
func (client *Client) Mobile3MetaSimpleStandardVerifyWithChan(request *Mobile3MetaSimpleStandardVerifyRequest) (<-chan *Mobile3MetaSimpleStandardVerifyResponse, <-chan error) {
	responseChan := make(chan *Mobile3MetaSimpleStandardVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Mobile3MetaSimpleStandardVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Mobile3MetaSimpleStandardVerifyWithCallback invokes the cloudauth.Mobile3MetaSimpleStandardVerify API asynchronously
func (client *Client) Mobile3MetaSimpleStandardVerifyWithCallback(request *Mobile3MetaSimpleStandardVerifyRequest, callback func(response *Mobile3MetaSimpleStandardVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Mobile3MetaSimpleStandardVerifyResponse
		var err error
		defer close(result)
		response, err = client.Mobile3MetaSimpleStandardVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Mobile3MetaSimpleStandardVerifyRequest is the request struct for api Mobile3MetaSimpleStandardVerify
type Mobile3MetaSimpleStandardVerifyRequest struct {
	*requests.RpcRequest
	ParamType   string `position:"Body" name:"ParamType"`
	Mobile      string `position:"Body" name:"Mobile"`
	IdentifyNum string `position:"Body" name:"IdentifyNum"`
	UserName    string `position:"Body" name:"UserName"`
}

// Mobile3MetaSimpleStandardVerifyResponse is the response struct for api Mobile3MetaSimpleStandardVerify
type Mobile3MetaSimpleStandardVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateMobile3MetaSimpleStandardVerifyRequest creates a request to invoke Mobile3MetaSimpleStandardVerify API
func CreateMobile3MetaSimpleStandardVerifyRequest() (request *Mobile3MetaSimpleStandardVerifyRequest) {
	request = &Mobile3MetaSimpleStandardVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "Mobile3MetaSimpleStandardVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMobile3MetaSimpleStandardVerifyResponse creates a response to parse from Mobile3MetaSimpleStandardVerify response
func CreateMobile3MetaSimpleStandardVerifyResponse() (response *Mobile3MetaSimpleStandardVerifyResponse) {
	response = &Mobile3MetaSimpleStandardVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
