package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckAssumeRole invokes the cloudcallcenter.CheckAssumeRole API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/checkassumerole.html
func (client *Client) CheckAssumeRole(request *CheckAssumeRoleRequest) (response *CheckAssumeRoleResponse, err error) {
	response = CreateCheckAssumeRoleResponse()
	err = client.DoAction(request, response)
	return
}

// CheckAssumeRoleWithChan invokes the cloudcallcenter.CheckAssumeRole API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/checkassumerole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckAssumeRoleWithChan(request *CheckAssumeRoleRequest) (<-chan *CheckAssumeRoleResponse, <-chan error) {
	responseChan := make(chan *CheckAssumeRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckAssumeRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckAssumeRoleWithCallback invokes the cloudcallcenter.CheckAssumeRole API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/checkassumerole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckAssumeRoleWithCallback(request *CheckAssumeRoleRequest, callback func(response *CheckAssumeRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckAssumeRoleResponse
		var err error
		defer close(result)
		response, err = client.CheckAssumeRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckAssumeRoleRequest is the request struct for api CheckAssumeRole
type CheckAssumeRoleRequest struct {
	*requests.RpcRequest
}

// CheckAssumeRoleResponse is the response struct for api CheckAssumeRole
type CheckAssumeRoleResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	HasRole        bool   `json:"HasRole" xml:"HasRole"`
}

// CreateCheckAssumeRoleRequest creates a request to invoke CheckAssumeRole API
func CreateCheckAssumeRoleRequest() (request *CheckAssumeRoleRequest) {
	request = &CheckAssumeRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CheckAssumeRole", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckAssumeRoleResponse creates a response to parse from CheckAssumeRole response
func CreateCheckAssumeRoleResponse() (response *CheckAssumeRoleResponse) {
	response = &CheckAssumeRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
