package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddAddressBook invokes the cloudfw.AddAddressBook API synchronously
func (client *Client) AddAddressBook(request *AddAddressBookRequest) (response *AddAddressBookResponse, err error) {
	response = CreateAddAddressBookResponse()
	err = client.DoAction(request, response)
	return
}

// AddAddressBookWithChan invokes the cloudfw.AddAddressBook API asynchronously
func (client *Client) AddAddressBookWithChan(request *AddAddressBookRequest) (<-chan *AddAddressBookResponse, <-chan error) {
	responseChan := make(chan *AddAddressBookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddAddressBook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddAddressBookWithCallback invokes the cloudfw.AddAddressBook API asynchronously
func (client *Client) AddAddressBookWithCallback(request *AddAddressBookRequest, callback func(response *AddAddressBookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddAddressBookResponse
		var err error
		defer close(result)
		response, err = client.AddAddressBook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddAddressBookRequest is the request struct for api AddAddressBook
type AddAddressBookRequest struct {
	*requests.RpcRequest
	Description   string                   `position:"Query" name:"Description"`
	TagList       *[]AddAddressBookTagList `position:"Query" name:"TagList"  type:"Repeated"`
	GroupType     string                   `position:"Query" name:"GroupType"`
	SourceIp      string                   `position:"Query" name:"SourceIp"`
	AutoAddTagEcs string                   `position:"Query" name:"AutoAddTagEcs"`
	Lang          string                   `position:"Query" name:"Lang"`
	AddressList   string                   `position:"Query" name:"AddressList"`
	TagRelation   string                   `position:"Query" name:"TagRelation"`
	GroupName     string                   `position:"Query" name:"GroupName"`
}

// AddAddressBookTagList is a repeated param struct in AddAddressBookRequest
type AddAddressBookTagList struct {
	TagValue string `name:"TagValue"`
	TagKey   string `name:"TagKey"`
}

// AddAddressBookResponse is the response struct for api AddAddressBook
type AddAddressBookResponse struct {
	*responses.BaseResponse
	GroupUuid string `json:"GroupUuid" xml:"GroupUuid"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddAddressBookRequest creates a request to invoke AddAddressBook API
func CreateAddAddressBookRequest() (request *AddAddressBookRequest) {
	request = &AddAddressBookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "AddAddressBook", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddAddressBookResponse creates a response to parse from AddAddressBook response
func CreateAddAddressBookResponse() (response *AddAddressBookResponse) {
	response = &AddAddressBookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
