package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Cursor invokes the cms.Cursor API synchronously
func (client *Client) Cursor(request *CursorRequest) (response *CursorResponse, err error) {
	response = CreateCursorResponse()
	err = client.DoAction(request, response)
	return
}

// CursorWithChan invokes the cms.Cursor API asynchronously
func (client *Client) CursorWithChan(request *CursorRequest) (<-chan *CursorResponse, <-chan error) {
	responseChan := make(chan *CursorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Cursor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CursorWithCallback invokes the cms.Cursor API asynchronously
func (client *Client) CursorWithCallback(request *CursorRequest, callback func(response *CursorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CursorResponse
		var err error
		defer close(result)
		response, err = client.Cursor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CursorRequest is the request struct for api Cursor
type CursorRequest struct {
	*requests.RpcRequest
	Period    requests.Integer `position:"Body" name:"Period"`
	EndTime   string           `position:"Body" name:"EndTime"`
	StartTime string           `position:"Body" name:"StartTime"`
	Matchers  string           `position:"Body" name:"Matchers"`
	Metric    string           `position:"Body" name:"Metric"`
	Namespace string           `position:"Body" name:"Namespace"`
}

// CursorResponse is the response struct for api Cursor
type CursorResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	Cursor    string `json:"Cursor" xml:"Cursor"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCursorRequest creates a request to invoke Cursor API
func CreateCursorRequest() (request *CursorRequest) {
	request = &CursorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "Cursor", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCursorResponse creates a response to parse from Cursor response
func CreateCursorResponse() (response *CursorResponse) {
	response = &CursorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
