package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMetricRuleBlackList invokes the cms.DeleteMetricRuleBlackList API synchronously
func (client *Client) DeleteMetricRuleBlackList(request *DeleteMetricRuleBlackListRequest) (response *DeleteMetricRuleBlackListResponse, err error) {
	response = CreateDeleteMetricRuleBlackListResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMetricRuleBlackListWithChan invokes the cms.DeleteMetricRuleBlackList API asynchronously
func (client *Client) DeleteMetricRuleBlackListWithChan(request *DeleteMetricRuleBlackListRequest) (<-chan *DeleteMetricRuleBlackListResponse, <-chan error) {
	responseChan := make(chan *DeleteMetricRuleBlackListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMetricRuleBlackList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMetricRuleBlackListWithCallback invokes the cms.DeleteMetricRuleBlackList API asynchronously
func (client *Client) DeleteMetricRuleBlackListWithCallback(request *DeleteMetricRuleBlackListRequest, callback func(response *DeleteMetricRuleBlackListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMetricRuleBlackListResponse
		var err error
		defer close(result)
		response, err = client.DeleteMetricRuleBlackList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMetricRuleBlackListRequest is the request struct for api DeleteMetricRuleBlackList
type DeleteMetricRuleBlackListRequest struct {
	*requests.RpcRequest
	Id string `position:"Query" name:"Id"`
}

// DeleteMetricRuleBlackListResponse is the response struct for api DeleteMetricRuleBlackList
type DeleteMetricRuleBlackListResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Count     int    `json:"Count" xml:"Count"`
}

// CreateDeleteMetricRuleBlackListRequest creates a request to invoke DeleteMetricRuleBlackList API
func CreateDeleteMetricRuleBlackListRequest() (request *DeleteMetricRuleBlackListRequest) {
	request = &DeleteMetricRuleBlackListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DeleteMetricRuleBlackList", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMetricRuleBlackListResponse creates a response to parse from DeleteMetricRuleBlackList response
func CreateDeleteMetricRuleBlackListResponse() (response *DeleteMetricRuleBlackListResponse) {
	response = &DeleteMetricRuleBlackListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
