package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMonitorGroupDynamicRule invokes the cms.DeleteMonitorGroupDynamicRule API synchronously
func (client *Client) DeleteMonitorGroupDynamicRule(request *DeleteMonitorGroupDynamicRuleRequest) (response *DeleteMonitorGroupDynamicRuleResponse, err error) {
	response = CreateDeleteMonitorGroupDynamicRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMonitorGroupDynamicRuleWithChan invokes the cms.DeleteMonitorGroupDynamicRule API asynchronously
func (client *Client) DeleteMonitorGroupDynamicRuleWithChan(request *DeleteMonitorGroupDynamicRuleRequest) (<-chan *DeleteMonitorGroupDynamicRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteMonitorGroupDynamicRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMonitorGroupDynamicRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMonitorGroupDynamicRuleWithCallback invokes the cms.DeleteMonitorGroupDynamicRule API asynchronously
func (client *Client) DeleteMonitorGroupDynamicRuleWithCallback(request *DeleteMonitorGroupDynamicRuleRequest, callback func(response *DeleteMonitorGroupDynamicRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMonitorGroupDynamicRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteMonitorGroupDynamicRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMonitorGroupDynamicRuleRequest is the request struct for api DeleteMonitorGroupDynamicRule
type DeleteMonitorGroupDynamicRuleRequest struct {
	*requests.RpcRequest
	GroupId  requests.Integer `position:"Query" name:"GroupId"`
	Category string           `position:"Query" name:"Category"`
}

// DeleteMonitorGroupDynamicRuleResponse is the response struct for api DeleteMonitorGroupDynamicRule
type DeleteMonitorGroupDynamicRuleResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteMonitorGroupDynamicRuleRequest creates a request to invoke DeleteMonitorGroupDynamicRule API
func CreateDeleteMonitorGroupDynamicRuleRequest() (request *DeleteMonitorGroupDynamicRuleRequest) {
	request = &DeleteMonitorGroupDynamicRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DeleteMonitorGroupDynamicRule", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteMonitorGroupDynamicRuleResponse creates a response to parse from DeleteMonitorGroupDynamicRule response
func CreateDeleteMonitorGroupDynamicRuleResponse() (response *DeleteMonitorGroupDynamicRuleResponse) {
	response = &DeleteMonitorGroupDynamicRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
