package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeHybridMonitorNamespaceList invokes the cms.DescribeHybridMonitorNamespaceList API synchronously
func (client *Client) DescribeHybridMonitorNamespaceList(request *DescribeHybridMonitorNamespaceListRequest) (response *DescribeHybridMonitorNamespaceListResponse, err error) {
	response = CreateDescribeHybridMonitorNamespaceListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeHybridMonitorNamespaceListWithChan invokes the cms.DescribeHybridMonitorNamespaceList API asynchronously
func (client *Client) DescribeHybridMonitorNamespaceListWithChan(request *DescribeHybridMonitorNamespaceListRequest) (<-chan *DescribeHybridMonitorNamespaceListResponse, <-chan error) {
	responseChan := make(chan *DescribeHybridMonitorNamespaceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeHybridMonitorNamespaceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeHybridMonitorNamespaceListWithCallback invokes the cms.DescribeHybridMonitorNamespaceList API asynchronously
func (client *Client) DescribeHybridMonitorNamespaceListWithCallback(request *DescribeHybridMonitorNamespaceListRequest, callback func(response *DescribeHybridMonitorNamespaceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeHybridMonitorNamespaceListResponse
		var err error
		defer close(result)
		response, err = client.DescribeHybridMonitorNamespaceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeHybridMonitorNamespaceListRequest is the request struct for api DescribeHybridMonitorNamespaceList
type DescribeHybridMonitorNamespaceListRequest struct {
	*requests.RpcRequest
	PageNumber        requests.Integer `position:"Query" name:"PageNumber"`
	ShowTaskStatistic requests.Boolean `position:"Query" name:"ShowTaskStatistic"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	Namespace         string           `position:"Query" name:"Namespace"`
	IsDelete          string           `position:"Query" name:"IsDelete"`
	Keyword           string           `position:"Query" name:"Keyword"`
}

// DescribeHybridMonitorNamespaceListResponse is the response struct for api DescribeHybridMonitorNamespaceList
type DescribeHybridMonitorNamespaceListResponse struct {
	*responses.BaseResponse
	RequestId                      string                               `json:"RequestId" xml:"RequestId"`
	Success                        string                               `json:"Success" xml:"Success"`
	Code                           string                               `json:"Code" xml:"Code"`
	Message                        string                               `json:"Message" xml:"Message"`
	PageSize                       int                                  `json:"PageSize" xml:"PageSize"`
	PageNumber                     int                                  `json:"PageNumber" xml:"PageNumber"`
	Total                          int                                  `json:"Total" xml:"Total"`
	DescribeHybridMonitorNamespace []DescribeHybridMonitorNamespaceItem `json:"DescribeHybridMonitorNamespace" xml:"DescribeHybridMonitorNamespace"`
}

// CreateDescribeHybridMonitorNamespaceListRequest creates a request to invoke DescribeHybridMonitorNamespaceList API
func CreateDescribeHybridMonitorNamespaceListRequest() (request *DescribeHybridMonitorNamespaceListRequest) {
	request = &DescribeHybridMonitorNamespaceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeHybridMonitorNamespaceList", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeHybridMonitorNamespaceListResponse creates a response to parse from DescribeHybridMonitorNamespaceList response
func CreateDescribeHybridMonitorNamespaceListResponse() (response *DescribeHybridMonitorNamespaceListResponse) {
	response = &DescribeHybridMonitorNamespaceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
