package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyGroupMonitoringAgentProcess invokes the cms.ModifyGroupMonitoringAgentProcess API synchronously
func (client *Client) ModifyGroupMonitoringAgentProcess(request *ModifyGroupMonitoringAgentProcessRequest) (response *ModifyGroupMonitoringAgentProcessResponse, err error) {
	response = CreateModifyGroupMonitoringAgentProcessResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyGroupMonitoringAgentProcessWithChan invokes the cms.ModifyGroupMonitoringAgentProcess API asynchronously
func (client *Client) ModifyGroupMonitoringAgentProcessWithChan(request *ModifyGroupMonitoringAgentProcessRequest) (<-chan *ModifyGroupMonitoringAgentProcessResponse, <-chan error) {
	responseChan := make(chan *ModifyGroupMonitoringAgentProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyGroupMonitoringAgentProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyGroupMonitoringAgentProcessWithCallback invokes the cms.ModifyGroupMonitoringAgentProcess API asynchronously
func (client *Client) ModifyGroupMonitoringAgentProcessWithCallback(request *ModifyGroupMonitoringAgentProcessRequest, callback func(response *ModifyGroupMonitoringAgentProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyGroupMonitoringAgentProcessResponse
		var err error
		defer close(result)
		response, err = client.ModifyGroupMonitoringAgentProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyGroupMonitoringAgentProcessRequest is the request struct for api ModifyGroupMonitoringAgentProcess
type ModifyGroupMonitoringAgentProcessRequest struct {
	*requests.RpcRequest
	AlertConfig                *[]ModifyGroupMonitoringAgentProcessAlertConfig `position:"Query" name:"AlertConfig"  type:"Repeated"`
	GroupId                    string                                          `position:"Query" name:"GroupId"`
	MatchExpressFilterRelation string                                          `position:"Query" name:"MatchExpressFilterRelation"`
	Id                         string                                          `position:"Query" name:"Id"`
}

// ModifyGroupMonitoringAgentProcessAlertConfig is a repeated param struct in ModifyGroupMonitoringAgentProcessRequest
type ModifyGroupMonitoringAgentProcessAlertConfig struct {
	Times               string                                                        `name:"Times"`
	Webhook             string                                                        `name:"Webhook"`
	NoEffectiveInterval string                                                        `name:"NoEffectiveInterval"`
	TargetList          *[]ModifyGroupMonitoringAgentProcessAlertConfigTargetListItem `name:"TargetList" type:"Repeated"`
	SilenceTime         string                                                        `name:"SilenceTime"`
	Threshold           string                                                        `name:"Threshold"`
	ComparisonOperator  string                                                        `name:"ComparisonOperator"`
	EffectiveInterval   string                                                        `name:"EffectiveInterval"`
	EscalationsLevel    string                                                        `name:"EscalationsLevel"`
	Statistics          string                                                        `name:"Statistics"`
}

// ModifyGroupMonitoringAgentProcessAlertConfigTargetListItem is a repeated param struct in ModifyGroupMonitoringAgentProcessRequest
type ModifyGroupMonitoringAgentProcessAlertConfigTargetListItem struct {
	Level      string `name:"Level"`
	Id         string `name:"Id"`
	Arn        string `name:"Arn"`
	JsonParams string `name:"JsonParams"`
}

// ModifyGroupMonitoringAgentProcessResponse is the response struct for api ModifyGroupMonitoringAgentProcess
type ModifyGroupMonitoringAgentProcessResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyGroupMonitoringAgentProcessRequest creates a request to invoke ModifyGroupMonitoringAgentProcess API
func CreateModifyGroupMonitoringAgentProcessRequest() (request *ModifyGroupMonitoringAgentProcessRequest) {
	request = &ModifyGroupMonitoringAgentProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "ModifyGroupMonitoringAgentProcess", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyGroupMonitoringAgentProcessResponse creates a response to parse from ModifyGroupMonitoringAgentProcess response
func CreateModifyGroupMonitoringAgentProcessResponse() (response *ModifyGroupMonitoringAgentProcessResponse) {
	response = &ModifyGroupMonitoringAgentProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
