package companyreg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindProduceAuthorization invokes the companyreg.BindProduceAuthorization API synchronously
func (client *Client) BindProduceAuthorization(request *BindProduceAuthorizationRequest) (response *BindProduceAuthorizationResponse, err error) {
	response = CreateBindProduceAuthorizationResponse()
	err = client.DoAction(request, response)
	return
}

// BindProduceAuthorizationWithChan invokes the companyreg.BindProduceAuthorization API asynchronously
func (client *Client) BindProduceAuthorizationWithChan(request *BindProduceAuthorizationRequest) (<-chan *BindProduceAuthorizationResponse, <-chan error) {
	responseChan := make(chan *BindProduceAuthorizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindProduceAuthorization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindProduceAuthorizationWithCallback invokes the companyreg.BindProduceAuthorization API asynchronously
func (client *Client) BindProduceAuthorizationWithCallback(request *BindProduceAuthorizationRequest, callback func(response *BindProduceAuthorizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindProduceAuthorizationResponse
		var err error
		defer close(result)
		response, err = client.BindProduceAuthorization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindProduceAuthorizationRequest is the request struct for api BindProduceAuthorization
type BindProduceAuthorizationRequest struct {
	*requests.RpcRequest
	BizType           string `position:"Body" name:"BizType"`
	AuthorizedUserIds string `position:"Body" name:"AuthorizedUserIds"`
	BizId             string `position:"Body" name:"BizId"`
}

// BindProduceAuthorizationResponse is the response struct for api BindProduceAuthorization
type BindProduceAuthorizationResponse struct {
	*responses.BaseResponse
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateBindProduceAuthorizationRequest creates a request to invoke BindProduceAuthorization API
func CreateBindProduceAuthorizationRequest() (request *BindProduceAuthorizationRequest) {
	request = &BindProduceAuthorizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("companyreg", "2020-03-06", "BindProduceAuthorization", "companyreg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindProduceAuthorizationResponse creates a response to parse from BindProduceAuthorization response
func CreateBindProduceAuthorizationResponse() (response *BindProduceAuthorizationResponse) {
	response = &BindProduceAuthorizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
