package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddServiceSharedAccounts invokes the computenestsupplier.AddServiceSharedAccounts API synchronously
func (client *Client) AddServiceSharedAccounts(request *AddServiceSharedAccountsRequest) (response *AddServiceSharedAccountsResponse, err error) {
	response = CreateAddServiceSharedAccountsResponse()
	err = client.DoAction(request, response)
	return
}

// AddServiceSharedAccountsWithChan invokes the computenestsupplier.AddServiceSharedAccounts API asynchronously
func (client *Client) AddServiceSharedAccountsWithChan(request *AddServiceSharedAccountsRequest) (<-chan *AddServiceSharedAccountsResponse, <-chan error) {
	responseChan := make(chan *AddServiceSharedAccountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddServiceSharedAccounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddServiceSharedAccountsWithCallback invokes the computenestsupplier.AddServiceSharedAccounts API asynchronously
func (client *Client) AddServiceSharedAccountsWithCallback(request *AddServiceSharedAccountsRequest, callback func(response *AddServiceSharedAccountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddServiceSharedAccountsResponse
		var err error
		defer close(result)
		response, err = client.AddServiceSharedAccounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddServiceSharedAccountsRequest is the request struct for api AddServiceSharedAccounts
type AddServiceSharedAccountsRequest struct {
	*requests.RpcRequest
	ClientToken    string                                    `position:"Query" name:"ClientToken"`
	Type           string                                    `position:"Query" name:"Type"`
	SharedAccounts *[]AddServiceSharedAccountsSharedAccounts `position:"Query" name:"SharedAccounts"  type:"Repeated"`
	ServiceId      string                                    `position:"Query" name:"ServiceId"`
}

// AddServiceSharedAccountsSharedAccounts is a repeated param struct in AddServiceSharedAccountsRequest
type AddServiceSharedAccountsSharedAccounts struct {
	UserAliUid string `name:"UserAliUid"`
	Permission string `name:"Permission"`
}

// AddServiceSharedAccountsResponse is the response struct for api AddServiceSharedAccounts
type AddServiceSharedAccountsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddServiceSharedAccountsRequest creates a request to invoke AddServiceSharedAccounts API
func CreateAddServiceSharedAccountsRequest() (request *AddServiceSharedAccountsRequest) {
	request = &AddServiceSharedAccountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "AddServiceSharedAccounts", "", "")
	request.Method = requests.POST
	return
}

// CreateAddServiceSharedAccountsResponse creates a response to parse from AddServiceSharedAccounts response
func CreateAddServiceSharedAccountsResponse() (response *AddServiceSharedAccountsResponse) {
	response = &AddServiceSharedAccountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
