package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceInstance invokes the computenestsupplier.GetServiceInstance API synchronously
func (client *Client) GetServiceInstance(request *GetServiceInstanceRequest) (response *GetServiceInstanceResponse, err error) {
	response = CreateGetServiceInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceInstanceWithChan invokes the computenestsupplier.GetServiceInstance API asynchronously
func (client *Client) GetServiceInstanceWithChan(request *GetServiceInstanceRequest) (<-chan *GetServiceInstanceResponse, <-chan error) {
	responseChan := make(chan *GetServiceInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceInstanceWithCallback invokes the computenestsupplier.GetServiceInstance API asynchronously
func (client *Client) GetServiceInstanceWithCallback(request *GetServiceInstanceRequest, callback func(response *GetServiceInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceInstanceResponse
		var err error
		defer close(result)
		response, err = client.GetServiceInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceInstanceRequest is the request struct for api GetServiceInstance
type GetServiceInstanceRequest struct {
	*requests.RpcRequest
	ServiceInstanceId string `position:"Query" name:"ServiceInstanceId"`
}

// GetServiceInstanceResponse is the response struct for api GetServiceInstance
type GetServiceInstanceResponse struct {
	*responses.BaseResponse
	Status                    string        `json:"Status" xml:"Status"`
	TemplateName              string        `json:"TemplateName" xml:"TemplateName"`
	UpdateTime                string        `json:"UpdateTime" xml:"UpdateTime"`
	RequestId                 string        `json:"RequestId" xml:"RequestId"`
	ServiceInstanceId         string        `json:"ServiceInstanceId" xml:"ServiceInstanceId"`
	CreateTime                string        `json:"CreateTime" xml:"CreateTime"`
	UserId                    int64         `json:"UserId" xml:"UserId"`
	SupplierUid               int64         `json:"SupplierUid" xml:"SupplierUid"`
	Parameters                string        `json:"Parameters" xml:"Parameters"`
	Progress                  int64         `json:"Progress" xml:"Progress"`
	StatusDetail              string        `json:"StatusDetail" xml:"StatusDetail"`
	OperationStartTime        string        `json:"OperationStartTime" xml:"OperationStartTime"`
	OperationEndTime          string        `json:"OperationEndTime" xml:"OperationEndTime"`
	OperatedServiceInstanceId string        `json:"OperatedServiceInstanceId" xml:"OperatedServiceInstanceId"`
	IsOperated                bool          `json:"IsOperated" xml:"IsOperated"`
	EnableInstanceOps         bool          `json:"EnableInstanceOps" xml:"EnableInstanceOps"`
	Resources                 string        `json:"Resources" xml:"Resources"`
	Outputs                   string        `json:"Outputs" xml:"Outputs"`
	EndTime                   string        `json:"EndTime" xml:"EndTime"`
	Source                    string        `json:"Source" xml:"Source"`
	ServiceType               string        `json:"ServiceType" xml:"ServiceType"`
	PayType                   string        `json:"PayType" xml:"PayType"`
	LicenseMetadata           string        `json:"LicenseMetadata" xml:"LicenseMetadata"`
	Name                      string        `json:"Name" xml:"Name"`
	EnableUserPrometheus      bool          `json:"EnableUserPrometheus" xml:"EnableUserPrometheus"`
	RdAccountLoginUrl         string        `json:"RdAccountLoginUrl" xml:"RdAccountLoginUrl"`
	PredefinedParameterName   string        `json:"PredefinedParameterName" xml:"PredefinedParameterName"`
	ResourceGroupId           string        `json:"ResourceGroupId" xml:"ResourceGroupId"`
	BizStatus                 string        `json:"BizStatus" xml:"BizStatus"`
	GrafanaDashBoardUrl       string        `json:"GrafanaDashBoardUrl" xml:"GrafanaDashBoardUrl"`
	Service                   Service       `json:"Service" xml:"Service"`
	NetworkConfig             NetworkConfig `json:"NetworkConfig" xml:"NetworkConfig"`
	Tags                      []Tag         `json:"Tags" xml:"Tags"`
}

// CreateGetServiceInstanceRequest creates a request to invoke GetServiceInstance API
func CreateGetServiceInstanceRequest() (request *GetServiceInstanceRequest) {
	request = &GetServiceInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "GetServiceInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateGetServiceInstanceResponse creates a response to parse from GetServiceInstance response
func CreateGetServiceInstanceResponse() (response *GetServiceInstanceResponse) {
	response = &GetServiceInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
