package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAcrImageRepositories invokes the computenestsupplier.ListAcrImageRepositories API synchronously
func (client *Client) ListAcrImageRepositories(request *ListAcrImageRepositoriesRequest) (response *ListAcrImageRepositoriesResponse, err error) {
	response = CreateListAcrImageRepositoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListAcrImageRepositoriesWithChan invokes the computenestsupplier.ListAcrImageRepositories API asynchronously
func (client *Client) ListAcrImageRepositoriesWithChan(request *ListAcrImageRepositoriesRequest) (<-chan *ListAcrImageRepositoriesResponse, <-chan error) {
	responseChan := make(chan *ListAcrImageRepositoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAcrImageRepositories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAcrImageRepositoriesWithCallback invokes the computenestsupplier.ListAcrImageRepositories API asynchronously
func (client *Client) ListAcrImageRepositoriesWithCallback(request *ListAcrImageRepositoriesRequest, callback func(response *ListAcrImageRepositoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAcrImageRepositoriesResponse
		var err error
		defer close(result)
		response, err = client.ListAcrImageRepositories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAcrImageRepositoriesRequest is the request struct for api ListAcrImageRepositories
type ListAcrImageRepositoriesRequest struct {
	*requests.RpcRequest
	NextToken    string           `position:"Query" name:"NextToken"`
	ArtifactType string           `position:"Query" name:"ArtifactType"`
	RepoName     string           `position:"Query" name:"RepoName"`
	MaxResults   requests.Integer `position:"Query" name:"MaxResults"`
}

// ListAcrImageRepositoriesResponse is the response struct for api ListAcrImageRepositories
type ListAcrImageRepositoriesResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	NextToken    string             `json:"NextToken" xml:"NextToken"`
	MaxResults   int                `json:"MaxResults" xml:"MaxResults"`
	TotalCount   int                `json:"TotalCount" xml:"TotalCount"`
	Repositories []RepositoriesItem `json:"Repositories" xml:"Repositories"`
}

// CreateListAcrImageRepositoriesRequest creates a request to invoke ListAcrImageRepositories API
func CreateListAcrImageRepositoriesRequest() (request *ListAcrImageRepositoriesRequest) {
	request = &ListAcrImageRepositoriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "ListAcrImageRepositories", "", "")
	request.Method = requests.POST
	return
}

// CreateListAcrImageRepositoriesResponse creates a response to parse from ListAcrImageRepositories response
func CreateListAcrImageRepositoriesResponse() (response *ListAcrImageRepositoriesResponse) {
	response = &ListAcrImageRepositoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
