package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CopyConfigRules invokes the config.CopyConfigRules API synchronously
func (client *Client) CopyConfigRules(request *CopyConfigRulesRequest) (response *CopyConfigRulesResponse, err error) {
	response = CreateCopyConfigRulesResponse()
	err = client.DoAction(request, response)
	return
}

// CopyConfigRulesWithChan invokes the config.CopyConfigRules API asynchronously
func (client *Client) CopyConfigRulesWithChan(request *CopyConfigRulesRequest) (<-chan *CopyConfigRulesResponse, <-chan error) {
	responseChan := make(chan *CopyConfigRulesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CopyConfigRules(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CopyConfigRulesWithCallback invokes the config.CopyConfigRules API asynchronously
func (client *Client) CopyConfigRulesWithCallback(request *CopyConfigRulesRequest, callback func(response *CopyConfigRulesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CopyConfigRulesResponse
		var err error
		defer close(result)
		response, err = client.CopyConfigRules(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CopyConfigRulesRequest is the request struct for api CopyConfigRules
type CopyConfigRulesRequest struct {
	*requests.RpcRequest
	DesAggregatorIds string `position:"Query" name:"DesAggregatorIds"`
	SrcConfigRuleIds string `position:"Query" name:"SrcConfigRuleIds"`
	SrcAggregatorId  string `position:"Query" name:"SrcAggregatorId"`
}

// CopyConfigRulesResponse is the response struct for api CopyConfigRules
type CopyConfigRulesResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	CopyRulesResult bool   `json:"CopyRulesResult" xml:"CopyRulesResult"`
}

// CreateCopyConfigRulesRequest creates a request to invoke CopyConfigRules API
func CreateCopyConfigRulesRequest() (request *CopyConfigRulesRequest) {
	request = &CopyConfigRulesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "CopyConfigRules", "", "")
	request.Method = requests.POST
	return
}

// CreateCopyConfigRulesResponse creates a response to parse from CopyConfigRules response
func CreateCopyConfigRulesResponse() (response *CopyConfigRulesResponse) {
	response = &CopyConfigRulesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
