package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateComplianceSummary invokes the config.GetAggregateComplianceSummary API synchronously
func (client *Client) GetAggregateComplianceSummary(request *GetAggregateComplianceSummaryRequest) (response *GetAggregateComplianceSummaryResponse, err error) {
	response = CreateGetAggregateComplianceSummaryResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateComplianceSummaryWithChan invokes the config.GetAggregateComplianceSummary API asynchronously
func (client *Client) GetAggregateComplianceSummaryWithChan(request *GetAggregateComplianceSummaryRequest) (<-chan *GetAggregateComplianceSummaryResponse, <-chan error) {
	responseChan := make(chan *GetAggregateComplianceSummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateComplianceSummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateComplianceSummaryWithCallback invokes the config.GetAggregateComplianceSummary API asynchronously
func (client *Client) GetAggregateComplianceSummaryWithCallback(request *GetAggregateComplianceSummaryRequest, callback func(response *GetAggregateComplianceSummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateComplianceSummaryResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateComplianceSummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateComplianceSummaryRequest is the request struct for api GetAggregateComplianceSummary
type GetAggregateComplianceSummaryRequest struct {
	*requests.RpcRequest
	AggregatorId string `position:"Query" name:"AggregatorId"`
}

// GetAggregateComplianceSummaryResponse is the response struct for api GetAggregateComplianceSummary
type GetAggregateComplianceSummaryResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	ComplianceSummary ComplianceSummary `json:"ComplianceSummary" xml:"ComplianceSummary"`
}

// CreateGetAggregateComplianceSummaryRequest creates a request to invoke GetAggregateComplianceSummary API
func CreateGetAggregateComplianceSummaryRequest() (request *GetAggregateComplianceSummaryRequest) {
	request = &GetAggregateComplianceSummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateComplianceSummary", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAggregateComplianceSummaryResponse creates a response to parse from GetAggregateComplianceSummary response
func CreateGetAggregateComplianceSummaryResponse() (response *GetAggregateComplianceSummaryResponse) {
	response = &GetAggregateComplianceSummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
