package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateConfigRuleComplianceByPack invokes the config.GetAggregateConfigRuleComplianceByPack API synchronously
func (client *Client) GetAggregateConfigRuleComplianceByPack(request *GetAggregateConfigRuleComplianceByPackRequest) (response *GetAggregateConfigRuleComplianceByPackResponse, err error) {
	response = CreateGetAggregateConfigRuleComplianceByPackResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateConfigRuleComplianceByPackWithChan invokes the config.GetAggregateConfigRuleComplianceByPack API asynchronously
func (client *Client) GetAggregateConfigRuleComplianceByPackWithChan(request *GetAggregateConfigRuleComplianceByPackRequest) (<-chan *GetAggregateConfigRuleComplianceByPackResponse, <-chan error) {
	responseChan := make(chan *GetAggregateConfigRuleComplianceByPackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateConfigRuleComplianceByPack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateConfigRuleComplianceByPackWithCallback invokes the config.GetAggregateConfigRuleComplianceByPack API asynchronously
func (client *Client) GetAggregateConfigRuleComplianceByPackWithCallback(request *GetAggregateConfigRuleComplianceByPackRequest, callback func(response *GetAggregateConfigRuleComplianceByPackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateConfigRuleComplianceByPackResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateConfigRuleComplianceByPack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateConfigRuleComplianceByPackRequest is the request struct for api GetAggregateConfigRuleComplianceByPack
type GetAggregateConfigRuleComplianceByPackRequest struct {
	*requests.RpcRequest
	AggregatorId     string `position:"Query" name:"AggregatorId"`
	CompliancePackId string `position:"Query" name:"CompliancePackId"`
}

// GetAggregateConfigRuleComplianceByPackResponse is the response struct for api GetAggregateConfigRuleComplianceByPack
type GetAggregateConfigRuleComplianceByPackResponse struct {
	*responses.BaseResponse
	RequestId                  string                     `json:"RequestId" xml:"RequestId"`
	ConfigRuleComplianceResult ConfigRuleComplianceResult `json:"ConfigRuleComplianceResult" xml:"ConfigRuleComplianceResult"`
}

// CreateGetAggregateConfigRuleComplianceByPackRequest creates a request to invoke GetAggregateConfigRuleComplianceByPack API
func CreateGetAggregateConfigRuleComplianceByPackRequest() (request *GetAggregateConfigRuleComplianceByPackRequest) {
	request = &GetAggregateConfigRuleComplianceByPackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateConfigRuleComplianceByPack", "", "")
	request.Method = requests.GET
	return
}

// CreateGetAggregateConfigRuleComplianceByPackResponse creates a response to parse from GetAggregateConfigRuleComplianceByPack response
func CreateGetAggregateConfigRuleComplianceByPackResponse() (response *GetAggregateConfigRuleComplianceByPackResponse) {
	response = &GetAggregateConfigRuleComplianceByPackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
