package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAggregateConfigRuleEvaluationResults invokes the config.ListAggregateConfigRuleEvaluationResults API synchronously
func (client *Client) ListAggregateConfigRuleEvaluationResults(request *ListAggregateConfigRuleEvaluationResultsRequest) (response *ListAggregateConfigRuleEvaluationResultsResponse, err error) {
	response = CreateListAggregateConfigRuleEvaluationResultsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAggregateConfigRuleEvaluationResultsWithChan invokes the config.ListAggregateConfigRuleEvaluationResults API asynchronously
func (client *Client) ListAggregateConfigRuleEvaluationResultsWithChan(request *ListAggregateConfigRuleEvaluationResultsRequest) (<-chan *ListAggregateConfigRuleEvaluationResultsResponse, <-chan error) {
	responseChan := make(chan *ListAggregateConfigRuleEvaluationResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAggregateConfigRuleEvaluationResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAggregateConfigRuleEvaluationResultsWithCallback invokes the config.ListAggregateConfigRuleEvaluationResults API asynchronously
func (client *Client) ListAggregateConfigRuleEvaluationResultsWithCallback(request *ListAggregateConfigRuleEvaluationResultsRequest, callback func(response *ListAggregateConfigRuleEvaluationResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAggregateConfigRuleEvaluationResultsResponse
		var err error
		defer close(result)
		response, err = client.ListAggregateConfigRuleEvaluationResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAggregateConfigRuleEvaluationResultsRequest is the request struct for api ListAggregateConfigRuleEvaluationResults
type ListAggregateConfigRuleEvaluationResultsRequest struct {
	*requests.RpcRequest
	ConfigRuleId      string           `position:"Query" name:"ConfigRuleId"`
	ResourceOwnerId   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Regions           string           `position:"Query" name:"Regions"`
	AggregatorId      string           `position:"Query" name:"AggregatorId"`
	ResourceAccountId requests.Integer `position:"Query" name:"ResourceAccountId"`
	NextToken         string           `position:"Query" name:"NextToken"`
	CompliancePackId  string           `position:"Query" name:"CompliancePackId"`
	ComplianceType    string           `position:"Query" name:"ComplianceType"`
	ResourceTypes     string           `position:"Query" name:"ResourceTypes"`
	ResourceGroupIds  string           `position:"Query" name:"ResourceGroupIds"`
	MaxResults        requests.Integer `position:"Query" name:"MaxResults"`
}

// ListAggregateConfigRuleEvaluationResultsResponse is the response struct for api ListAggregateConfigRuleEvaluationResults
type ListAggregateConfigRuleEvaluationResultsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	EvaluationResults EvaluationResults `json:"EvaluationResults" xml:"EvaluationResults"`
}

// CreateListAggregateConfigRuleEvaluationResultsRequest creates a request to invoke ListAggregateConfigRuleEvaluationResults API
func CreateListAggregateConfigRuleEvaluationResultsRequest() (request *ListAggregateConfigRuleEvaluationResultsRequest) {
	request = &ListAggregateConfigRuleEvaluationResultsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "ListAggregateConfigRuleEvaluationResults", "", "")
	request.Method = requests.POST
	return
}

// CreateListAggregateConfigRuleEvaluationResultsResponse creates a response to parse from ListAggregateConfigRuleEvaluationResults response
func CreateListAggregateConfigRuleEvaluationResultsResponse() (response *ListAggregateConfigRuleEvaluationResultsResponse) {
	response = &ListAggregateConfigRuleEvaluationResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
