package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachPolicy2ApprovalProcess invokes the csas.AttachPolicy2ApprovalProcess API synchronously
func (client *Client) AttachPolicy2ApprovalProcess(request *AttachPolicy2ApprovalProcessRequest) (response *AttachPolicy2ApprovalProcessResponse, err error) {
	response = CreateAttachPolicy2ApprovalProcessResponse()
	err = client.DoAction(request, response)
	return
}

// AttachPolicy2ApprovalProcessWithChan invokes the csas.AttachPolicy2ApprovalProcess API asynchronously
func (client *Client) AttachPolicy2ApprovalProcessWithChan(request *AttachPolicy2ApprovalProcessRequest) (<-chan *AttachPolicy2ApprovalProcessResponse, <-chan error) {
	responseChan := make(chan *AttachPolicy2ApprovalProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachPolicy2ApprovalProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachPolicy2ApprovalProcessWithCallback invokes the csas.AttachPolicy2ApprovalProcess API asynchronously
func (client *Client) AttachPolicy2ApprovalProcessWithCallback(request *AttachPolicy2ApprovalProcessRequest, callback func(response *AttachPolicy2ApprovalProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachPolicy2ApprovalProcessResponse
		var err error
		defer close(result)
		response, err = client.AttachPolicy2ApprovalProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachPolicy2ApprovalProcessRequest is the request struct for api AttachPolicy2ApprovalProcess
type AttachPolicy2ApprovalProcessRequest struct {
	*requests.RpcRequest
	PolicyType string `position:"Body" name:"PolicyType"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	PolicyId   string `position:"Body" name:"PolicyId"`
	ProcessId  string `position:"Body" name:"ProcessId"`
}

// AttachPolicy2ApprovalProcessResponse is the response struct for api AttachPolicy2ApprovalProcess
type AttachPolicy2ApprovalProcessResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachPolicy2ApprovalProcessRequest creates a request to invoke AttachPolicy2ApprovalProcess API
func CreateAttachPolicy2ApprovalProcessRequest() (request *AttachPolicy2ApprovalProcessRequest) {
	request = &AttachPolicy2ApprovalProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "AttachPolicy2ApprovalProcess", "", "")
	request.Method = requests.POST
	return
}

// CreateAttachPolicy2ApprovalProcessResponse creates a response to parse from AttachPolicy2ApprovalProcess response
func CreateAttachPolicy2ApprovalProcessResponse() (response *AttachPolicy2ApprovalProcessResponse) {
	response = &AttachPolicy2ApprovalProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
