package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrivateAccessTags invokes the csas.ListPrivateAccessTags API synchronously
func (client *Client) ListPrivateAccessTags(request *ListPrivateAccessTagsRequest) (response *ListPrivateAccessTagsResponse, err error) {
	response = CreateListPrivateAccessTagsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrivateAccessTagsWithChan invokes the csas.ListPrivateAccessTags API asynchronously
func (client *Client) ListPrivateAccessTagsWithChan(request *ListPrivateAccessTagsRequest) (<-chan *ListPrivateAccessTagsResponse, <-chan error) {
	responseChan := make(chan *ListPrivateAccessTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrivateAccessTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrivateAccessTagsWithCallback invokes the csas.ListPrivateAccessTags API asynchronously
func (client *Client) ListPrivateAccessTagsWithCallback(request *ListPrivateAccessTagsRequest, callback func(response *ListPrivateAccessTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrivateAccessTagsResponse
		var err error
		defer close(result)
		response, err = client.ListPrivateAccessTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrivateAccessTagsRequest is the request struct for api ListPrivateAccessTags
type ListPrivateAccessTagsRequest struct {
	*requests.RpcRequest
	SourceIp      string           `position:"Query" name:"SourceIp"`
	PolicyId      string           `position:"Query" name:"PolicyId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	ApplicationId string           `position:"Query" name:"ApplicationId"`
	SimpleMode    requests.Boolean `position:"Query" name:"SimpleMode"`
	TagIds        *[]string        `position:"Query" name:"TagIds"  type:"Repeated"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	Name          string           `position:"Query" name:"Name"`
}

// ListPrivateAccessTagsResponse is the response struct for api ListPrivateAccessTags
type ListPrivateAccessTagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TotalNum  int    `json:"TotalNum" xml:"TotalNum"`
	Tags      []Tag  `json:"Tags" xml:"Tags"`
}

// CreateListPrivateAccessTagsRequest creates a request to invoke ListPrivateAccessTags API
func CreateListPrivateAccessTagsRequest() (request *ListPrivateAccessTagsRequest) {
	request = &ListPrivateAccessTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListPrivateAccessTags", "", "")
	request.Method = requests.GET
	return
}

// CreateListPrivateAccessTagsResponse creates a response to parse from ListPrivateAccessTags response
func CreateListPrivateAccessTagsResponse() (response *ListPrivateAccessTagsResponse) {
	response = &ListPrivateAccessTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
