package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrivateAccessTagsForDynamicRoute invokes the csas.ListPrivateAccessTagsForDynamicRoute API synchronously
func (client *Client) ListPrivateAccessTagsForDynamicRoute(request *ListPrivateAccessTagsForDynamicRouteRequest) (response *ListPrivateAccessTagsForDynamicRouteResponse, err error) {
	response = CreateListPrivateAccessTagsForDynamicRouteResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrivateAccessTagsForDynamicRouteWithChan invokes the csas.ListPrivateAccessTagsForDynamicRoute API asynchronously
func (client *Client) ListPrivateAccessTagsForDynamicRouteWithChan(request *ListPrivateAccessTagsForDynamicRouteRequest) (<-chan *ListPrivateAccessTagsForDynamicRouteResponse, <-chan error) {
	responseChan := make(chan *ListPrivateAccessTagsForDynamicRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrivateAccessTagsForDynamicRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrivateAccessTagsForDynamicRouteWithCallback invokes the csas.ListPrivateAccessTagsForDynamicRoute API asynchronously
func (client *Client) ListPrivateAccessTagsForDynamicRouteWithCallback(request *ListPrivateAccessTagsForDynamicRouteRequest, callback func(response *ListPrivateAccessTagsForDynamicRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrivateAccessTagsForDynamicRouteResponse
		var err error
		defer close(result)
		response, err = client.ListPrivateAccessTagsForDynamicRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrivateAccessTagsForDynamicRouteRequest is the request struct for api ListPrivateAccessTagsForDynamicRoute
type ListPrivateAccessTagsForDynamicRouteRequest struct {
	*requests.RpcRequest
	DynamicRouteIds *[]string `position:"Query" name:"DynamicRouteIds"  type:"Repeated"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
}

// ListPrivateAccessTagsForDynamicRouteResponse is the response struct for api ListPrivateAccessTagsForDynamicRoute
type ListPrivateAccessTagsForDynamicRouteResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	DynamicRoutes []DynamicRoute `json:"DynamicRoutes" xml:"DynamicRoutes"`
}

// CreateListPrivateAccessTagsForDynamicRouteRequest creates a request to invoke ListPrivateAccessTagsForDynamicRoute API
func CreateListPrivateAccessTagsForDynamicRouteRequest() (request *ListPrivateAccessTagsForDynamicRouteRequest) {
	request = &ListPrivateAccessTagsForDynamicRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListPrivateAccessTagsForDynamicRoute", "", "")
	request.Method = requests.GET
	return
}

// CreateListPrivateAccessTagsForDynamicRouteResponse creates a response to parse from ListPrivateAccessTagsForDynamicRoute response
func CreateListPrivateAccessTagsForDynamicRouteResponse() (response *ListPrivateAccessTagsForDynamicRouteResponse) {
	response = &ListPrivateAccessTagsForDynamicRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
