package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateResourceFile invokes the dataworks_public.CreateResourceFile API synchronously
func (client *Client) CreateResourceFile(request *CreateResourceFileRequest) (response *CreateResourceFileResponse, err error) {
	response = CreateCreateResourceFileResponse()
	err = client.DoAction(request, response)
	return
}

// CreateResourceFileWithChan invokes the dataworks_public.CreateResourceFile API asynchronously
func (client *Client) CreateResourceFileWithChan(request *CreateResourceFileRequest) (<-chan *CreateResourceFileResponse, <-chan error) {
	responseChan := make(chan *CreateResourceFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateResourceFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateResourceFileWithCallback invokes the dataworks_public.CreateResourceFile API asynchronously
func (client *Client) CreateResourceFileWithCallback(request *CreateResourceFileRequest, callback func(response *CreateResourceFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateResourceFileResponse
		var err error
		defer close(result)
		response, err = client.CreateResourceFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateResourceFileRequest is the request struct for api CreateResourceFile
type CreateResourceFileRequest struct {
	*requests.RpcRequest
	FileType             requests.Integer `position:"Body" name:"FileType"`
	Content              string           `position:"Body" name:"Content"`
	ResourceFile         string           `position:"Body" name:"ResourceFile"`
	OriginResourceName   string           `position:"Body" name:"OriginResourceName"`
	ProjectId            requests.Integer `position:"Body" name:"ProjectId"`
	StorageURL           string           `position:"Body" name:"StorageURL"`
	Owner                string           `position:"Body" name:"Owner"`
	RegisterToCalcEngine requests.Boolean `position:"Body" name:"RegisterToCalcEngine"`
	UploadMode           requests.Boolean `position:"Body" name:"UploadMode"`
	FileName             string           `position:"Body" name:"FileName"`
	FileFolderPath       string           `position:"Body" name:"FileFolderPath"`
	FileDescription      string           `position:"Body" name:"FileDescription"`
}

// CreateResourceFileResponse is the response struct for api CreateResourceFile
type CreateResourceFileResponse struct {
	*responses.BaseResponse
	Data      int64  `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateResourceFileRequest creates a request to invoke CreateResourceFile API
func CreateCreateResourceFileRequest() (request *CreateResourceFileRequest) {
	request = &CreateResourceFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateResourceFile", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateResourceFileResponse creates a response to parse from CreateResourceFile response
func CreateCreateResourceFileResponse() (response *CreateResourceFileResponse) {
	response = &CreateResourceFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
