package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EditRecognizeRule invokes the dataworks_public.EditRecognizeRule API synchronously
func (client *Client) EditRecognizeRule(request *EditRecognizeRuleRequest) (response *EditRecognizeRuleResponse, err error) {
	response = CreateEditRecognizeRuleResponse()
	err = client.DoAction(request, response)
	return
}

// EditRecognizeRuleWithChan invokes the dataworks_public.EditRecognizeRule API asynchronously
func (client *Client) EditRecognizeRuleWithChan(request *EditRecognizeRuleRequest) (<-chan *EditRecognizeRuleResponse, <-chan error) {
	responseChan := make(chan *EditRecognizeRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EditRecognizeRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EditRecognizeRuleWithCallback invokes the dataworks_public.EditRecognizeRule API asynchronously
func (client *Client) EditRecognizeRuleWithCallback(request *EditRecognizeRuleRequest, callback func(response *EditRecognizeRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EditRecognizeRuleResponse
		var err error
		defer close(result)
		response, err = client.EditRecognizeRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EditRecognizeRuleRequest is the request struct for api EditRecognizeRule
type EditRecognizeRuleRequest struct {
	*requests.RpcRequest
	Level                string           `position:"Body" name:"level"`
	ColScan              string           `position:"Body" name:"ColScan"`
	ColExclude           string           `position:"Body" name:"ColExclude"`
	ContentScan          string           `position:"Body" name:"ContentScan"`
	OperationType        requests.Integer `position:"Body" name:"OperationType"`
	TemplateId           string           `position:"Body" name:"TemplateId"`
	RecognizeRulesType   string           `position:"Body" name:"RecognizeRulesType"`
	CommentScan          string           `position:"Body" name:"CommentScan"`
	AccountName          string           `position:"Body" name:"AccountName"`
	SensitiveDescription string           `position:"Body" name:"SensitiveDescription"`
	SensitiveId          string           `position:"Body" name:"SensitiveId"`
	TenantId             string           `position:"Body" name:"TenantId"`
	RecognizeRules       string           `position:"Body" name:"RecognizeRules"`
	HitThreshold         requests.Integer `position:"Body" name:"HitThreshold"`
	SensitiveName        string           `position:"Body" name:"SensitiveName"`
	NodeParent           string           `position:"Body" name:"NodeParent"`
	LevelName            string           `position:"Body" name:"LevelName"`
	NodeId               string           `position:"Body" name:"NodeId"`
	Status               requests.Integer `position:"Body" name:"Status"`
}

// EditRecognizeRuleResponse is the response struct for api EditRecognizeRule
type EditRecognizeRuleResponse struct {
	*responses.BaseResponse
}

// CreateEditRecognizeRuleRequest creates a request to invoke EditRecognizeRule API
func CreateEditRecognizeRuleRequest() (request *EditRecognizeRuleRequest) {
	request = &EditRecognizeRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "EditRecognizeRule", "", "")
	request.Method = requests.POST
	return
}

// CreateEditRecognizeRuleResponse creates a response to parse from EditRecognizeRule response
func CreateEditRecognizeRuleResponse() (response *EditRecognizeRuleResponse) {
	response = &EditRecognizeRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
