package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainMultiUsageData invokes the dcdn.DescribeDcdnDomainMultiUsageData API synchronously
func (client *Client) DescribeDcdnDomainMultiUsageData(request *DescribeDcdnDomainMultiUsageDataRequest) (response *DescribeDcdnDomainMultiUsageDataResponse, err error) {
	response = CreateDescribeDcdnDomainMultiUsageDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainMultiUsageDataWithChan invokes the dcdn.DescribeDcdnDomainMultiUsageData API asynchronously
func (client *Client) DescribeDcdnDomainMultiUsageDataWithChan(request *DescribeDcdnDomainMultiUsageDataRequest) (<-chan *DescribeDcdnDomainMultiUsageDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainMultiUsageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainMultiUsageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainMultiUsageDataWithCallback invokes the dcdn.DescribeDcdnDomainMultiUsageData API asynchronously
func (client *Client) DescribeDcdnDomainMultiUsageDataWithCallback(request *DescribeDcdnDomainMultiUsageDataRequest, callback func(response *DescribeDcdnDomainMultiUsageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainMultiUsageDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainMultiUsageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainMultiUsageDataRequest is the request struct for api DescribeDcdnDomainMultiUsageData
type DescribeDcdnDomainMultiUsageDataRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
	StartTime  string `position:"Query" name:"StartTime"`
}

// DescribeDcdnDomainMultiUsageDataResponse is the response struct for api DescribeDcdnDomainMultiUsageData
type DescribeDcdnDomainMultiUsageDataResponse struct {
	*responses.BaseResponse
	EndTime            string             `json:"EndTime" xml:"EndTime"`
	StartTime          string             `json:"StartTime" xml:"StartTime"`
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	RequestPerInterval RequestPerInterval `json:"RequestPerInterval" xml:"RequestPerInterval"`
	TrafficPerInterval TrafficPerInterval `json:"TrafficPerInterval" xml:"TrafficPerInterval"`
}

// CreateDescribeDcdnDomainMultiUsageDataRequest creates a request to invoke DescribeDcdnDomainMultiUsageData API
func CreateDescribeDcdnDomainMultiUsageDataRequest() (request *DescribeDcdnDomainMultiUsageDataRequest) {
	request = &DescribeDcdnDomainMultiUsageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainMultiUsageData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainMultiUsageDataResponse creates a response to parse from DescribeDcdnDomainMultiUsageData response
func CreateDescribeDcdnDomainMultiUsageDataResponse() (response *DescribeDcdnDomainMultiUsageDataResponse) {
	response = &DescribeDcdnDomainMultiUsageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
