package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnUserConfigs invokes the dcdn.DescribeDcdnUserConfigs API synchronously
func (client *Client) DescribeDcdnUserConfigs(request *DescribeDcdnUserConfigsRequest) (response *DescribeDcdnUserConfigsResponse, err error) {
	response = CreateDescribeDcdnUserConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnUserConfigsWithChan invokes the dcdn.DescribeDcdnUserConfigs API asynchronously
func (client *Client) DescribeDcdnUserConfigsWithChan(request *DescribeDcdnUserConfigsRequest) (<-chan *DescribeDcdnUserConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnUserConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnUserConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnUserConfigsWithCallback invokes the dcdn.DescribeDcdnUserConfigs API asynchronously
func (client *Client) DescribeDcdnUserConfigsWithCallback(request *DescribeDcdnUserConfigsRequest, callback func(response *DescribeDcdnUserConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnUserConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnUserConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnUserConfigsRequest is the request struct for api DescribeDcdnUserConfigs
type DescribeDcdnUserConfigsRequest struct {
	*requests.RpcRequest
	FunctionName string `position:"Query" name:"FunctionName"`
}

// DescribeDcdnUserConfigsResponse is the response struct for api DescribeDcdnUserConfigs
type DescribeDcdnUserConfigsResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Configs   []Config `json:"Configs" xml:"Configs"`
}

// CreateDescribeDcdnUserConfigsRequest creates a request to invoke DescribeDcdnUserConfigs API
func CreateDescribeDcdnUserConfigsRequest() (request *DescribeDcdnUserConfigsRequest) {
	request = &DescribeDcdnUserConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnUserConfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnUserConfigsResponse creates a response to parse from DescribeDcdnUserConfigs response
func CreateDescribeDcdnUserConfigsResponse() (response *DescribeDcdnUserConfigsResponse) {
	response = &DescribeDcdnUserConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
