package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnUserRealTimeDeliveryField invokes the dcdn.DescribeDcdnUserRealTimeDeliveryField API synchronously
func (client *Client) DescribeDcdnUserRealTimeDeliveryField(request *DescribeDcdnUserRealTimeDeliveryFieldRequest) (response *DescribeDcdnUserRealTimeDeliveryFieldResponse, err error) {
	response = CreateDescribeDcdnUserRealTimeDeliveryFieldResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnUserRealTimeDeliveryFieldWithChan invokes the dcdn.DescribeDcdnUserRealTimeDeliveryField API asynchronously
func (client *Client) DescribeDcdnUserRealTimeDeliveryFieldWithChan(request *DescribeDcdnUserRealTimeDeliveryFieldRequest) (<-chan *DescribeDcdnUserRealTimeDeliveryFieldResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnUserRealTimeDeliveryFieldResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnUserRealTimeDeliveryField(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnUserRealTimeDeliveryFieldWithCallback invokes the dcdn.DescribeDcdnUserRealTimeDeliveryField API asynchronously
func (client *Client) DescribeDcdnUserRealTimeDeliveryFieldWithCallback(request *DescribeDcdnUserRealTimeDeliveryFieldRequest, callback func(response *DescribeDcdnUserRealTimeDeliveryFieldResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnUserRealTimeDeliveryFieldResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnUserRealTimeDeliveryField(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnUserRealTimeDeliveryFieldRequest is the request struct for api DescribeDcdnUserRealTimeDeliveryField
type DescribeDcdnUserRealTimeDeliveryFieldRequest struct {
	*requests.RpcRequest
	BusinessType string `position:"Query" name:"BusinessType"`
}

// DescribeDcdnUserRealTimeDeliveryFieldResponse is the response struct for api DescribeDcdnUserRealTimeDeliveryField
type DescribeDcdnUserRealTimeDeliveryFieldResponse struct {
	*responses.BaseResponse
	RequestId string                                         `json:"RequestId" xml:"RequestId"`
	Content   ContentInDescribeDcdnUserRealTimeDeliveryField `json:"Content" xml:"Content"`
}

// CreateDescribeDcdnUserRealTimeDeliveryFieldRequest creates a request to invoke DescribeDcdnUserRealTimeDeliveryField API
func CreateDescribeDcdnUserRealTimeDeliveryFieldRequest() (request *DescribeDcdnUserRealTimeDeliveryFieldRequest) {
	request = &DescribeDcdnUserRealTimeDeliveryFieldRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnUserRealTimeDeliveryField", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDcdnUserRealTimeDeliveryFieldResponse creates a response to parse from DescribeDcdnUserRealTimeDeliveryField response
func CreateDescribeDcdnUserRealTimeDeliveryFieldResponse() (response *DescribeDcdnUserRealTimeDeliveryFieldResponse) {
	response = &DescribeDcdnUserRealTimeDeliveryFieldResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
