package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnWafUsageData invokes the dcdn.DescribeDcdnWafUsageData API synchronously
func (client *Client) DescribeDcdnWafUsageData(request *DescribeDcdnWafUsageDataRequest) (response *DescribeDcdnWafUsageDataResponse, err error) {
	response = CreateDescribeDcdnWafUsageDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnWafUsageDataWithChan invokes the dcdn.DescribeDcdnWafUsageData API asynchronously
func (client *Client) DescribeDcdnWafUsageDataWithChan(request *DescribeDcdnWafUsageDataRequest) (<-chan *DescribeDcdnWafUsageDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnWafUsageDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnWafUsageData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnWafUsageDataWithCallback invokes the dcdn.DescribeDcdnWafUsageData API asynchronously
func (client *Client) DescribeDcdnWafUsageDataWithCallback(request *DescribeDcdnWafUsageDataRequest, callback func(response *DescribeDcdnWafUsageDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnWafUsageDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnWafUsageData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnWafUsageDataRequest is the request struct for api DescribeDcdnWafUsageData
type DescribeDcdnWafUsageDataRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	EndTime    string `position:"Query" name:"EndTime"`
	Interval   string `position:"Query" name:"Interval"`
	StartTime  string `position:"Query" name:"StartTime"`
	SplitBy    string `position:"Query" name:"SplitBy"`
}

// DescribeDcdnWafUsageDataResponse is the response struct for api DescribeDcdnWafUsageData
type DescribeDcdnWafUsageDataResponse struct {
	*responses.BaseResponse
	EndTime      string       `json:"EndTime" xml:"EndTime"`
	StartTime    string       `json:"StartTime" xml:"StartTime"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	WafUsageData WafUsageData `json:"WafUsageData" xml:"WafUsageData"`
}

// CreateDescribeDcdnWafUsageDataRequest creates a request to invoke DescribeDcdnWafUsageData API
func CreateDescribeDcdnWafUsageDataRequest() (request *DescribeDcdnWafUsageDataRequest) {
	request = &DescribeDcdnWafUsageDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnWafUsageData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnWafUsageDataResponse creates a response to parse from DescribeDcdnWafUsageData response
func CreateDescribeDcdnWafUsageDataResponse() (response *DescribeDcdnWafUsageDataResponse) {
	response = &DescribeDcdnWafUsageDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
