package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDcdnDomainSSLCertificate invokes the dcdn.SetDcdnDomainSSLCertificate API synchronously
func (client *Client) SetDcdnDomainSSLCertificate(request *SetDcdnDomainSSLCertificateRequest) (response *SetDcdnDomainSSLCertificateResponse, err error) {
	response = CreateSetDcdnDomainSSLCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// SetDcdnDomainSSLCertificateWithChan invokes the dcdn.SetDcdnDomainSSLCertificate API asynchronously
func (client *Client) SetDcdnDomainSSLCertificateWithChan(request *SetDcdnDomainSSLCertificateRequest) (<-chan *SetDcdnDomainSSLCertificateResponse, <-chan error) {
	responseChan := make(chan *SetDcdnDomainSSLCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDcdnDomainSSLCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDcdnDomainSSLCertificateWithCallback invokes the dcdn.SetDcdnDomainSSLCertificate API asynchronously
func (client *Client) SetDcdnDomainSSLCertificateWithCallback(request *SetDcdnDomainSSLCertificateRequest, callback func(response *SetDcdnDomainSSLCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDcdnDomainSSLCertificateResponse
		var err error
		defer close(result)
		response, err = client.SetDcdnDomainSSLCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDcdnDomainSSLCertificateRequest is the request struct for api SetDcdnDomainSSLCertificate
type SetDcdnDomainSSLCertificateRequest struct {
	*requests.RpcRequest
	SSLProtocol   string           `position:"Query" name:"SSLProtocol"`
	CertId        requests.Integer `position:"Query" name:"CertId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	CertType      string           `position:"Query" name:"CertType"`
	SSLPri        string           `position:"Query" name:"SSLPri"`
	CertRegion    string           `position:"Query" name:"CertRegion"`
	CertName      string           `position:"Query" name:"CertName"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	Env           string           `position:"Query" name:"Env"`
	SSLPub        string           `position:"Query" name:"SSLPub"`
}

// SetDcdnDomainSSLCertificateResponse is the response struct for api SetDcdnDomainSSLCertificate
type SetDcdnDomainSSLCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDcdnDomainSSLCertificateRequest creates a request to invoke SetDcdnDomainSSLCertificate API
func CreateSetDcdnDomainSSLCertificateRequest() (request *SetDcdnDomainSSLCertificateRequest) {
	request = &SetDcdnDomainSSLCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "SetDcdnDomainSSLCertificate", "", "")
	request.Method = requests.POST
	return
}

// CreateSetDcdnDomainSSLCertificateResponse creates a response to parse from SetDcdnDomainSSLCertificate response
func CreateSetDcdnDomainSSLCertificateResponse() (response *SetDcdnDomainSSLCertificateResponse) {
	response = &SetDcdnDomainSSLCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
