package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySchedruleOnDemand invokes the ddosbgp.QuerySchedruleOnDemand API synchronously
func (client *Client) QuerySchedruleOnDemand(request *QuerySchedruleOnDemandRequest) (response *QuerySchedruleOnDemandResponse, err error) {
	response = CreateQuerySchedruleOnDemandResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySchedruleOnDemandWithChan invokes the ddosbgp.QuerySchedruleOnDemand API asynchronously
func (client *Client) QuerySchedruleOnDemandWithChan(request *QuerySchedruleOnDemandRequest) (<-chan *QuerySchedruleOnDemandResponse, <-chan error) {
	responseChan := make(chan *QuerySchedruleOnDemandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySchedruleOnDemand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySchedruleOnDemandWithCallback invokes the ddosbgp.QuerySchedruleOnDemand API asynchronously
func (client *Client) QuerySchedruleOnDemandWithCallback(request *QuerySchedruleOnDemandRequest, callback func(response *QuerySchedruleOnDemandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySchedruleOnDemandResponse
		var err error
		defer close(result)
		response, err = client.QuerySchedruleOnDemand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySchedruleOnDemandRequest is the request struct for api QuerySchedruleOnDemand
type QuerySchedruleOnDemandRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// QuerySchedruleOnDemandResponse is the response struct for api QuerySchedruleOnDemand
type QuerySchedruleOnDemandResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	InstanceId string   `json:"InstanceId" xml:"InstanceId"`
	UserId     string   `json:"UserId" xml:"UserId"`
	RuleConfig []Config `json:"RuleConfig" xml:"RuleConfig"`
	RuleStatus []Status `json:"RuleStatus" xml:"RuleStatus"`
}

// CreateQuerySchedruleOnDemandRequest creates a request to invoke QuerySchedruleOnDemand API
func CreateQuerySchedruleOnDemandRequest() (request *QuerySchedruleOnDemandRequest) {
	request = &QuerySchedruleOnDemandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "QuerySchedruleOnDemand", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySchedruleOnDemandResponse creates a response to parse from QuerySchedruleOnDemand response
func CreateQuerySchedruleOnDemandResponse() (response *QuerySchedruleOnDemandResponse) {
	response = &QuerySchedruleOnDemandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
