package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddAutoCcBlacklist invokes the ddoscoo.AddAutoCcBlacklist API synchronously
func (client *Client) AddAutoCcBlacklist(request *AddAutoCcBlacklistRequest) (response *AddAutoCcBlacklistResponse, err error) {
	response = CreateAddAutoCcBlacklistResponse()
	err = client.DoAction(request, response)
	return
}

// AddAutoCcBlacklistWithChan invokes the ddoscoo.AddAutoCcBlacklist API asynchronously
func (client *Client) AddAutoCcBlacklistWithChan(request *AddAutoCcBlacklistRequest) (<-chan *AddAutoCcBlacklistResponse, <-chan error) {
	responseChan := make(chan *AddAutoCcBlacklistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddAutoCcBlacklist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddAutoCcBlacklistWithCallback invokes the ddoscoo.AddAutoCcBlacklist API asynchronously
func (client *Client) AddAutoCcBlacklistWithCallback(request *AddAutoCcBlacklistRequest, callback func(response *AddAutoCcBlacklistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddAutoCcBlacklistResponse
		var err error
		defer close(result)
		response, err = client.AddAutoCcBlacklist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddAutoCcBlacklistRequest is the request struct for api AddAutoCcBlacklist
type AddAutoCcBlacklistRequest struct {
	*requests.RpcRequest
	ExpireTime requests.Integer `position:"Query" name:"ExpireTime"`
	Blacklist  string           `position:"Query" name:"Blacklist"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	SourceIp   string           `position:"Query" name:"SourceIp"`
}

// AddAutoCcBlacklistResponse is the response struct for api AddAutoCcBlacklist
type AddAutoCcBlacklistResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddAutoCcBlacklistRequest creates a request to invoke AddAutoCcBlacklist API
func CreateAddAutoCcBlacklistRequest() (request *AddAutoCcBlacklistRequest) {
	request = &AddAutoCcBlacklistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "AddAutoCcBlacklist", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddAutoCcBlacklistResponse creates a response to parse from AddAutoCcBlacklist response
func CreateAddAutoCcBlacklistResponse() (response *AddAutoCcBlacklistResponse) {
	response = &AddAutoCcBlacklistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
