package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeColumnSecurityLevel invokes the dms_enterprise.ChangeColumnSecurityLevel API synchronously
func (client *Client) ChangeColumnSecurityLevel(request *ChangeColumnSecurityLevelRequest) (response *ChangeColumnSecurityLevelResponse, err error) {
	response = CreateChangeColumnSecurityLevelResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeColumnSecurityLevelWithChan invokes the dms_enterprise.ChangeColumnSecurityLevel API asynchronously
func (client *Client) ChangeColumnSecurityLevelWithChan(request *ChangeColumnSecurityLevelRequest) (<-chan *ChangeColumnSecurityLevelResponse, <-chan error) {
	responseChan := make(chan *ChangeColumnSecurityLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeColumnSecurityLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeColumnSecurityLevelWithCallback invokes the dms_enterprise.ChangeColumnSecurityLevel API asynchronously
func (client *Client) ChangeColumnSecurityLevelWithCallback(request *ChangeColumnSecurityLevelRequest, callback func(response *ChangeColumnSecurityLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeColumnSecurityLevelResponse
		var err error
		defer close(result)
		response, err = client.ChangeColumnSecurityLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeColumnSecurityLevelRequest is the request struct for api ChangeColumnSecurityLevel
type ChangeColumnSecurityLevelRequest struct {
	*requests.RpcRequest
	NewSensitivityLevel string           `position:"Query" name:"NewSensitivityLevel"`
	Tid                 requests.Integer `position:"Query" name:"Tid"`
	TableName           string           `position:"Query" name:"TableName"`
	SchemaName          string           `position:"Query" name:"SchemaName"`
	IsLogic             requests.Boolean `position:"Query" name:"IsLogic"`
	ColumnName          string           `position:"Query" name:"ColumnName"`
	DbId                requests.Integer `position:"Query" name:"DbId"`
}

// ChangeColumnSecurityLevelResponse is the response struct for api ChangeColumnSecurityLevel
type ChangeColumnSecurityLevelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateChangeColumnSecurityLevelRequest creates a request to invoke ChangeColumnSecurityLevel API
func CreateChangeColumnSecurityLevelRequest() (request *ChangeColumnSecurityLevelRequest) {
	request = &ChangeColumnSecurityLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ChangeColumnSecurityLevel", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateChangeColumnSecurityLevelResponse creates a response to parse from ChangeColumnSecurityLevel response
func CreateChangeColumnSecurityLevelResponse() (response *ChangeColumnSecurityLevelResponse) {
	response = &ChangeColumnSecurityLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
