package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDataTrackOrder invokes the dms_enterprise.CreateDataTrackOrder API synchronously
func (client *Client) CreateDataTrackOrder(request *CreateDataTrackOrderRequest) (response *CreateDataTrackOrderResponse, err error) {
	response = CreateCreateDataTrackOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDataTrackOrderWithChan invokes the dms_enterprise.CreateDataTrackOrder API asynchronously
func (client *Client) CreateDataTrackOrderWithChan(request *CreateDataTrackOrderRequest) (<-chan *CreateDataTrackOrderResponse, <-chan error) {
	responseChan := make(chan *CreateDataTrackOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDataTrackOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDataTrackOrderWithCallback invokes the dms_enterprise.CreateDataTrackOrder API asynchronously
func (client *Client) CreateDataTrackOrderWithCallback(request *CreateDataTrackOrderRequest, callback func(response *CreateDataTrackOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDataTrackOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateDataTrackOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDataTrackOrderRequest is the request struct for api CreateDataTrackOrder
type CreateDataTrackOrderRequest struct {
	*requests.RpcRequest
	Tid             requests.Integer          `position:"Query" name:"Tid"`
	Param           CreateDataTrackOrderParam `position:"Query" name:"Param"  type:"Struct"`
	RelatedUserList *[]string                 `position:"Query" name:"RelatedUserList"  type:"Json"`
	Comment         string                    `position:"Query" name:"Comment"`
}

// CreateDataTrackOrderParam is a repeated param struct in CreateDataTrackOrderRequest
type CreateDataTrackOrderParam struct {
	JobEndTime   string    `name:"JobEndTime"`
	TrackTypes   *[]string `name:"TrackTypes" type:"Repeated"`
	TableNames   *[]string `name:"TableNames" type:"Repeated"`
	DbId         string    `name:"DbId"`
	JobStartTime string    `name:"JobStartTime"`
}

// CreateDataTrackOrderResponse is the response struct for api CreateDataTrackOrder
type CreateDataTrackOrderResponse struct {
	*responses.BaseResponse
	RequestId         string  `json:"RequestId" xml:"RequestId"`
	Success           bool    `json:"Success" xml:"Success"`
	ErrorMessage      string  `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode         string  `json:"ErrorCode" xml:"ErrorCode"`
	CreateOrderResult []int64 `json:"CreateOrderResult" xml:"CreateOrderResult"`
}

// CreateCreateDataTrackOrderRequest creates a request to invoke CreateDataTrackOrder API
func CreateCreateDataTrackOrderRequest() (request *CreateDataTrackOrderRequest) {
	request = &CreateDataTrackOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateDataTrackOrder", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDataTrackOrderResponse creates a response to parse from CreateDataTrackOrder response
func CreateCreateDataTrackOrderResponse() (response *CreateDataTrackOrderResponse) {
	response = &CreateDataTrackOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
