package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateStandardGroup invokes the dms_enterprise.CreateStandardGroup API synchronously
func (client *Client) CreateStandardGroup(request *CreateStandardGroupRequest) (response *CreateStandardGroupResponse, err error) {
	response = CreateCreateStandardGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateStandardGroupWithChan invokes the dms_enterprise.CreateStandardGroup API asynchronously
func (client *Client) CreateStandardGroupWithChan(request *CreateStandardGroupRequest) (<-chan *CreateStandardGroupResponse, <-chan error) {
	responseChan := make(chan *CreateStandardGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateStandardGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateStandardGroupWithCallback invokes the dms_enterprise.CreateStandardGroup API asynchronously
func (client *Client) CreateStandardGroupWithCallback(request *CreateStandardGroupRequest, callback func(response *CreateStandardGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateStandardGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateStandardGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateStandardGroupRequest is the request struct for api CreateStandardGroup
type CreateStandardGroupRequest struct {
	*requests.RpcRequest
	Description string           `position:"Query" name:"Description"`
	Tid         requests.Integer `position:"Query" name:"Tid"`
	GroupName   string           `position:"Query" name:"GroupName"`
	DbType      string           `position:"Query" name:"DbType"`
}

// CreateStandardGroupResponse is the response struct for api CreateStandardGroup
type CreateStandardGroupResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Success       bool          `json:"Success" xml:"Success"`
	ErrorMessage  string        `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode     string        `json:"ErrorCode" xml:"ErrorCode"`
	StandardGroup StandardGroup `json:"StandardGroup" xml:"StandardGroup"`
}

// CreateCreateStandardGroupRequest creates a request to invoke CreateStandardGroup API
func CreateCreateStandardGroupRequest() (request *CreateStandardGroupRequest) {
	request = &CreateStandardGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateStandardGroup", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateStandardGroupResponse creates a response to parse from CreateStandardGroup response
func CreateCreateStandardGroupResponse() (response *CreateStandardGroupResponse) {
	response = &CreateStandardGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
