package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataImportSQL invokes the dms_enterprise.GetDataImportSQL API synchronously
func (client *Client) GetDataImportSQL(request *GetDataImportSQLRequest) (response *GetDataImportSQLResponse, err error) {
	response = CreateGetDataImportSQLResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataImportSQLWithChan invokes the dms_enterprise.GetDataImportSQL API asynchronously
func (client *Client) GetDataImportSQLWithChan(request *GetDataImportSQLRequest) (<-chan *GetDataImportSQLResponse, <-chan error) {
	responseChan := make(chan *GetDataImportSQLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataImportSQL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataImportSQLWithCallback invokes the dms_enterprise.GetDataImportSQL API asynchronously
func (client *Client) GetDataImportSQLWithCallback(request *GetDataImportSQLRequest, callback func(response *GetDataImportSQLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataImportSQLResponse
		var err error
		defer close(result)
		response, err = client.GetDataImportSQL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataImportSQLRequest is the request struct for api GetDataImportSQL
type GetDataImportSQLRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	SqlId   requests.Integer `position:"Query" name:"SqlId"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// GetDataImportSQLResponse is the response struct for api GetDataImportSQL
type GetDataImportSQLResponse struct {
	*responses.BaseResponse
	RequestId    string    `json:"RequestId" xml:"RequestId"`
	Success      bool      `json:"Success" xml:"Success"`
	ErrorMessage string    `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string    `json:"ErrorCode" xml:"ErrorCode"`
	SQLDetail    SQLDetail `json:"SQLDetail" xml:"SQLDetail"`
}

// CreateGetDataImportSQLRequest creates a request to invoke GetDataImportSQL API
func CreateGetDataImportSQLRequest() (request *GetDataImportSQLRequest) {
	request = &GetDataImportSQLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataImportSQL", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataImportSQLResponse creates a response to parse from GetDataImportSQL response
func CreateGetDataImportSQLResponse() (response *GetDataImportSQLResponse) {
	response = &GetDataImportSQLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
