package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OfflineTaskFlow invokes the dms_enterprise.OfflineTaskFlow API synchronously
func (client *Client) OfflineTaskFlow(request *OfflineTaskFlowRequest) (response *OfflineTaskFlowResponse, err error) {
	response = CreateOfflineTaskFlowResponse()
	err = client.DoAction(request, response)
	return
}

// OfflineTaskFlowWithChan invokes the dms_enterprise.OfflineTaskFlow API asynchronously
func (client *Client) OfflineTaskFlowWithChan(request *OfflineTaskFlowRequest) (<-chan *OfflineTaskFlowResponse, <-chan error) {
	responseChan := make(chan *OfflineTaskFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OfflineTaskFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OfflineTaskFlowWithCallback invokes the dms_enterprise.OfflineTaskFlow API asynchronously
func (client *Client) OfflineTaskFlowWithCallback(request *OfflineTaskFlowRequest, callback func(response *OfflineTaskFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OfflineTaskFlowResponse
		var err error
		defer close(result)
		response, err = client.OfflineTaskFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OfflineTaskFlowRequest is the request struct for api OfflineTaskFlow
type OfflineTaskFlowRequest struct {
	*requests.RpcRequest
	DagId requests.Integer `position:"Query" name:"DagId"`
	Tid   requests.Integer `position:"Query" name:"Tid"`
}

// OfflineTaskFlowResponse is the response struct for api OfflineTaskFlow
type OfflineTaskFlowResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateOfflineTaskFlowRequest creates a request to invoke OfflineTaskFlow API
func CreateOfflineTaskFlowRequest() (request *OfflineTaskFlowRequest) {
	request = &OfflineTaskFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "OfflineTaskFlow", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOfflineTaskFlowResponse creates a response to parse from OfflineTaskFlow response
func CreateOfflineTaskFlowResponse() (response *OfflineTaskFlowResponse) {
	response = &OfflineTaskFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
