package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReDeployLhDagVersion invokes the dms_enterprise.ReDeployLhDagVersion API synchronously
func (client *Client) ReDeployLhDagVersion(request *ReDeployLhDagVersionRequest) (response *ReDeployLhDagVersionResponse, err error) {
	response = CreateReDeployLhDagVersionResponse()
	err = client.DoAction(request, response)
	return
}

// ReDeployLhDagVersionWithChan invokes the dms_enterprise.ReDeployLhDagVersion API asynchronously
func (client *Client) ReDeployLhDagVersionWithChan(request *ReDeployLhDagVersionRequest) (<-chan *ReDeployLhDagVersionResponse, <-chan error) {
	responseChan := make(chan *ReDeployLhDagVersionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReDeployLhDagVersion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReDeployLhDagVersionWithCallback invokes the dms_enterprise.ReDeployLhDagVersion API asynchronously
func (client *Client) ReDeployLhDagVersionWithCallback(request *ReDeployLhDagVersionRequest, callback func(response *ReDeployLhDagVersionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReDeployLhDagVersionResponse
		var err error
		defer close(result)
		response, err = client.ReDeployLhDagVersion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReDeployLhDagVersionRequest is the request struct for api ReDeployLhDagVersion
type ReDeployLhDagVersionRequest struct {
	*requests.RpcRequest
	DagId      requests.Integer `position:"Query" name:"DagId"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	DagVersion requests.Integer `position:"Query" name:"DagVersion"`
}

// ReDeployLhDagVersionResponse is the response struct for api ReDeployLhDagVersion
type ReDeployLhDagVersionResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	DeployId     int64  `json:"DeployId" xml:"DeployId"`
}

// CreateReDeployLhDagVersionRequest creates a request to invoke ReDeployLhDagVersion API
func CreateReDeployLhDagVersionRequest() (request *ReDeployLhDagVersionRequest) {
	request = &ReDeployLhDagVersionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ReDeployLhDagVersion", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReDeployLhDagVersionResponse creates a response to parse from ReDeployLhDagVersion response
func CreateReDeployLhDagVersionResponse() (response *ReDeployLhDagVersionResponse) {
	response = &ReDeployLhDagVersionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
