package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskContent invokes the dms_enterprise.UpdateTaskContent API synchronously
func (client *Client) UpdateTaskContent(request *UpdateTaskContentRequest) (response *UpdateTaskContentResponse, err error) {
	response = CreateUpdateTaskContentResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskContentWithChan invokes the dms_enterprise.UpdateTaskContent API asynchronously
func (client *Client) UpdateTaskContentWithChan(request *UpdateTaskContentRequest) (<-chan *UpdateTaskContentResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskContentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskContent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskContentWithCallback invokes the dms_enterprise.UpdateTaskContent API asynchronously
func (client *Client) UpdateTaskContentWithCallback(request *UpdateTaskContentRequest, callback func(response *UpdateTaskContentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskContentResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskContent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskContentRequest is the request struct for api UpdateTaskContent
type UpdateTaskContentRequest struct {
	*requests.RpcRequest
	Tid         requests.Integer `position:"Query" name:"Tid"`
	NodeContent string           `position:"Query" name:"NodeContent"`
	NodeId      string           `position:"Query" name:"NodeId"`
}

// UpdateTaskContentResponse is the response struct for api UpdateTaskContent
type UpdateTaskContentResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateTaskContentRequest creates a request to invoke UpdateTaskContent API
func CreateUpdateTaskContentRequest() (request *UpdateTaskContentRequest) {
	request = &UpdateTaskContentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateTaskContent", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskContentResponse creates a response to parse from UpdateTaskContent response
func CreateUpdateTaskContentResponse() (response *UpdateTaskContentResponse) {
	response = &UpdateTaskContentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
