package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCardSmsLink invokes the dysmsapi.GetCardSmsLink API synchronously
func (client *Client) GetCardSmsLink(request *GetCardSmsLinkRequest) (response *GetCardSmsLinkResponse, err error) {
	response = CreateGetCardSmsLinkResponse()
	err = client.DoAction(request, response)
	return
}

// GetCardSmsLinkWithChan invokes the dysmsapi.GetCardSmsLink API asynchronously
func (client *Client) GetCardSmsLinkWithChan(request *GetCardSmsLinkRequest) (<-chan *GetCardSmsLinkResponse, <-chan error) {
	responseChan := make(chan *GetCardSmsLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCardSmsLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCardSmsLinkWithCallback invokes the dysmsapi.GetCardSmsLink API asynchronously
func (client *Client) GetCardSmsLinkWithCallback(request *GetCardSmsLinkRequest, callback func(response *GetCardSmsLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCardSmsLinkResponse
		var err error
		defer close(result)
		response, err = client.GetCardSmsLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCardSmsLinkRequest is the request struct for api GetCardSmsLink
type GetCardSmsLinkRequest struct {
	*requests.RpcRequest
	ProductCode           string           `position:"Query" name:"ProductCode"`
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CardLinkType          requests.Integer `position:"Query" name:"CardLinkType"`
	ShowTimes             requests.Integer `position:"Query" name:"ShowTimes"`
	ExpireTimes           requests.Integer `position:"Query" name:"ExpireTimes"`
	CardTemplateParamJson string           `position:"Query" name:"CardTemplateParamJson"`
	CardCodeType          requests.Integer `position:"Query" name:"CardCodeType"`
	CardTemplateCode      string           `position:"Query" name:"CardTemplateCode"`
	Domain                string           `position:"Query" name:"Domain"`
	OutId                 string           `position:"Query" name:"OutId"`
	SignNameJson          string           `position:"Query" name:"SignNameJson"`
	PhoneNumberJson       string           `position:"Query" name:"PhoneNumberJson"`
	CustomShortCodeJson   string           `position:"Query" name:"CustomShortCodeJson"`
}

// GetCardSmsLinkResponse is the response struct for api GetCardSmsLink
type GetCardSmsLinkResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetCardSmsLinkRequest creates a request to invoke GetCardSmsLink API
func CreateGetCardSmsLinkRequest() (request *GetCardSmsLinkRequest) {
	request = &GetCardSmsLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "GetCardSmsLink", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetCardSmsLinkResponse creates a response to parse from GetCardSmsLink response
func CreateGetCardSmsLinkResponse() (response *GetCardSmsLinkResponse) {
	response = &GetCardSmsLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
