package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCardSmsTemplateReport invokes the dysmsapi.QueryCardSmsTemplateReport API synchronously
func (client *Client) QueryCardSmsTemplateReport(request *QueryCardSmsTemplateReportRequest) (response *QueryCardSmsTemplateReportResponse, err error) {
	response = CreateQueryCardSmsTemplateReportResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCardSmsTemplateReportWithChan invokes the dysmsapi.QueryCardSmsTemplateReport API asynchronously
func (client *Client) QueryCardSmsTemplateReportWithChan(request *QueryCardSmsTemplateReportRequest) (<-chan *QueryCardSmsTemplateReportResponse, <-chan error) {
	responseChan := make(chan *QueryCardSmsTemplateReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCardSmsTemplateReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCardSmsTemplateReportWithCallback invokes the dysmsapi.QueryCardSmsTemplateReport API asynchronously
func (client *Client) QueryCardSmsTemplateReportWithCallback(request *QueryCardSmsTemplateReportRequest, callback func(response *QueryCardSmsTemplateReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCardSmsTemplateReportResponse
		var err error
		defer close(result)
		response, err = client.QueryCardSmsTemplateReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCardSmsTemplateReportRequest is the request struct for api QueryCardSmsTemplateReport
type QueryCardSmsTemplateReportRequest struct {
	*requests.RpcRequest
	ProductCode     string           `position:"Query" name:"ProductCode"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	StartDate       string           `position:"Query" name:"StartDate"`
	TemplateCodes   *[]string        `position:"Query" name:"TemplateCodes"  type:"Repeated"`
	EndDate         string           `position:"Query" name:"EndDate"`
}

// QueryCardSmsTemplateReportResponse is the response struct for api QueryCardSmsTemplateReport
type QueryCardSmsTemplateReportResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryCardSmsTemplateReportRequest creates a request to invoke QueryCardSmsTemplateReport API
func CreateQueryCardSmsTemplateReportRequest() (request *QueryCardSmsTemplateReportRequest) {
	request = &QueryCardSmsTemplateReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "QueryCardSmsTemplateReport", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryCardSmsTemplateReportResponse creates a response to parse from QueryCardSmsTemplateReport response
func CreateQueryCardSmsTemplateReportResponse() (response *QueryCardSmsTemplateReportResponse) {
	response = &QueryCardSmsTemplateReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
